/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GlaciteArrow
extends AbstractArrow {
    private static final String TAG_DURATION = "duration";
    private int duration = 200;

    public GlaciteArrow(EntityType<? extends GlaciteArrow> entityType, Level level) {
        super(entityType, level);
    }

    public GlaciteArrow(Level level, LivingEntity livingEntity, ItemStack itemStack, @Nullable ItemStack itemStack2) {
        super(ESEntities.GLACITE_ARROW.get(), livingEntity, level, itemStack, itemStack2);
    }

    public GlaciteArrow(Level level, double d, double e, double f, ItemStack itemStack, @Nullable ItemStack itemStack2) {
        super(ESEntities.GLACITE_ARROW.get(), d, e, f, level, itemStack, itemStack2);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide && !this.inGround) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    protected void doPostHurtEffects(LivingEntity livingEntity) {
        super.doPostHurtEffects(livingEntity);
        if (livingEntity.canFreeze()) {
            livingEntity.setTicksFrozen(Math.min(livingEntity.getTicksFrozen() + this.duration, 300));
        }
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        if (compoundTag.contains(TAG_DURATION)) {
            this.duration = compoundTag.getInt(TAG_DURATION);
        }
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putInt(TAG_DURATION, this.duration);
    }

    protected ItemStack getDefaultPickupItem() {
        return ESItems.GLACITE_ARROW.get().getDefaultInstance();
    }
}

