/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AirSacArrow
extends AbstractArrow {
    public AirSacArrow(EntityType<? extends AirSacArrow> entityType, Level level) {
        super(entityType, level);
    }

    public AirSacArrow(Level level, LivingEntity livingEntity, ItemStack itemStack, @Nullable ItemStack itemStack2) {
        super(ESEntities.AIR_SAC_ARROW.get(), livingEntity, level, itemStack, itemStack2);
    }

    public AirSacArrow(Level level, double d, double e, double f, ItemStack itemStack, @Nullable ItemStack itemStack2) {
        super(ESEntities.AIR_SAC_ARROW.get(), d, e, f, level, itemStack, itemStack2);
    }

    protected float getWaterInertia() {
        return 0.99f;
    }

    protected void applyGravity() {
        if (this.isInWater()) {
            double d = this.getGravity();
            if (d != 0.0) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -d * 0.5, 0.0));
            }
        } else {
            super.applyGravity();
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide && !this.inGround && this.isInWater()) {
            Vec3 pos = this.getBoundingBox().getBottomCenter().offsetRandom(this.getRandom(), this.getBbWidth());
            Vec3 speed = this.getDeltaMovement().normalize().offsetRandom(this.getRandom(), 0.3f).scale(-0.2);
            this.level().addParticle((ParticleOptions)ESParticles.ROOKFISH_INK.get(), pos.x, pos.y, pos.z, speed.x, speed.y, speed.z);
        }
    }

    protected ItemStack getDefaultPickupItem() {
        return ESItems.AIR_SAC_ARROW.get().getDefaultInstance();
    }
}

