/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import cn.leolezury.eternalstarlight.common.entity.living.phase.MultiBehaviorUser;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.GlobalVec3;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ESBoss
extends Monster
implements MultiBehaviorUser {
    private static final String TAG_INITIAL_POS = "initial_pos";
    private static final String TAG_SPAWNED = "spawned";
    private static final String TAG_PHASE = "phase";
    private static final String TAG_ACTIVATED = "activated";
    protected final List<String> fightParticipants = new ArrayList<String>();
    protected static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.defineId(ESBoss.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> BEHAVIOR_STATE = SynchedEntityData.defineId(ESBoss.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> BEHAVIOR_TICKS = SynchedEntityData.defineId(ESBoss.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Boolean> ACTIVATED = SynchedEntityData.defineId(ESBoss.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private GlobalVec3 initialPos = GlobalVec3.of((ResourceKey<Level>)Level.OVERWORLD, Vec3.ZERO);
    private boolean spawned = false;

    protected ESBoss(EntityType<? extends ESBoss> type, Level level) {
        super(type, level);
        if (level.isClientSide) {
            ClientHandlers.BOSSES.add((Mob)this);
        }
    }

    public int getPhase() {
        return (Integer)this.getEntityData().get(PHASE);
    }

    public void setPhase(int phase) {
        this.getEntityData().set(PHASE, (Object)phase);
    }

    @Override
    public int getBehaviorState() {
        return (Integer)this.getEntityData().get(BEHAVIOR_STATE);
    }

    @Override
    public void setBehaviorState(int behaviourState) {
        this.getEntityData().set(BEHAVIOR_STATE, (Object)behaviourState);
    }

    @Override
    public int getBehaviorTicks() {
        return (Integer)this.getEntityData().get(BEHAVIOR_TICKS);
    }

    @Override
    public void setBehaviorTicks(int behaviourTicks) {
        this.getEntityData().set(BEHAVIOR_TICKS, (Object)behaviourTicks);
    }

    public boolean isActivated() {
        return (Boolean)this.getEntityData().get(ACTIVATED);
    }

    public void setActivated(boolean activated) {
        this.getEntityData().set(ACTIVATED, (Object)activated);
        if (activated) {
            this.setBehaviorState(0);
            this.setBehaviorTicks(0);
        }
    }

    public GlobalVec3 getInitialPos() {
        return this.initialPos;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BEHAVIOR_STATE, (Object)0).define(BEHAVIOR_TICKS, (Object)0).define(PHASE, (Object)0).define(ACTIVATED, (Object)true);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData) {
        spawnGroupData = super.finalizeSpawn(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
        this.initializeBossOnFirstSpawn();
        return spawnGroupData;
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        if (compoundTag.contains(TAG_INITIAL_POS)) {
            GlobalVec3.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.get(TAG_INITIAL_POS)).resultOrPartial(s -> EternalStarlight.LOGGER.warn("Failed to parse boss initial pos: {}", s)).ifPresent(pos -> {
                this.initialPos = pos;
            });
        }
        this.spawned = compoundTag.getBoolean(TAG_SPAWNED);
        this.setPhase(compoundTag.getInt(TAG_PHASE));
        if (compoundTag.contains(TAG_ACTIVATED, 3)) {
            this.setActivated(compoundTag.getBoolean(TAG_ACTIVATED));
        }
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.put(TAG_INITIAL_POS, (Tag)GlobalVec3.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.initialPos).getOrThrow());
        compoundTag.putBoolean(TAG_SPAWNED, this.spawned);
        compoundTag.putInt(TAG_PHASE, this.getPhase());
        compoundTag.putBoolean(TAG_ACTIVATED, this.isActivated());
    }

    public boolean hurt(DamageSource source, float amount) {
        ServerPlayer player;
        Entity entity;
        boolean success = super.hurt(source, amount);
        if (success && (entity = source.getEntity()) instanceof ServerPlayer && !this.fightParticipants.contains((player = (ServerPlayer)entity).getName().getString())) {
            this.fightParticipants.add(player.getName().getString());
        }
        return success;
    }

    public void die(DamageSource source) {
        Object object;
        if (!this.level().isClientSide && (object = this.level().getServer()) instanceof MinecraftServer) {
            MinecraftServer server = object;
            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                for (String name : this.fightParticipants) {
                    if (!player.getName().getString().equals(name) || !player.isAlive() || player.level().dimension() != this.level().dimension()) continue;
                    CriteriaTriggers.PLAYER_KILLED_ENTITY.trigger(player, (Entity)this, source);
                }
            }
        }
        super.die(source);
    }

    public boolean removeWhenFarAway(double dist) {
        return false;
    }

    public boolean canChangeDimensions(Level level, Level level1) {
        return false;
    }

    public boolean startRiding(Entity entity, boolean bl) {
        return false;
    }

    public boolean canBossMove() {
        return true;
    }

    public void initializeBoss() {
        this.initialPos = GlobalVec3.of((ResourceKey<Level>)this.level().dimension(), this.position());
    }

    public void initializeBossOnFirstSpawn() {
        if (!this.spawned) {
            this.initializeBoss();
            this.spawned = true;
        }
    }

    public boolean shouldPlayBossMusic() {
        return this.isAlive() && this.getBossMusic() != null;
    }

    public SoundEvent getBossMusic() {
        return ESSoundEvents.MUSIC_BOSS.get();
    }

    public ResourceKey<LootTable> getBossLootTable() {
        ResourceLocation resourcelocation = BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getType());
        ResourceLocation lootTable = resourcelocation.withPrefix("bosses/");
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTable);
    }

    public ItemStack getBossLootBag() {
        ItemStack lootBag = new ItemStack((ItemLike)ESItems.LOOT_BAG.get());
        lootBag.applyComponentsAndValidate(DataComponentPatch.builder().set(DataComponents.LORE, (Object)new ItemLore(List.of(this.getDisplayName()))).set(ESDataComponents.LOOT_TABLE.get(), this.getBossLootTable()).build());
        return lootBag;
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource damageSource, boolean bl) {
        super.dropCustomDeathLoot(serverLevel, damageSource, bl);
        if (!this.level().isClientSide) {
            ItemEntity item;
            ItemStack lootBag = this.getBossLootBag();
            if (this.fightParticipants.isEmpty() && (item = this.spawnAtLocation(lootBag.copy())) != null) {
                item.setGlowingTag(true);
                item.setExtendedLifetime();
            }
            for (Player player : this.level().players()) {
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!this.fightParticipants.stream().anyMatch(s -> s.equals(player.getName().getString())) || !player.isAlive()) continue;
                ItemEntity item2 = player.spawnAtLocation(lootBag.copy());
                if (item2 != null) {
                    item2.setTarget(player.getUUID());
                    item2.setGlowingTag(true);
                    item2.setExtendedLifetime();
                }
                this.dropExtraLoot(serverPlayer);
            }
        }
    }

    public void dropExtraLoot(ServerPlayer player) {
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.initializeBossOnFirstSpawn();
            if (!this.canBossMove() && this.level().dimension() == this.initialPos.dimension()) {
                this.setPos(this.initialPos.pos().x, this.position().y, this.initialPos.pos().z);
            }
        }
    }
}

