/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.data;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.data.ESBiomes;
import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.world.gen.system.BiomeData;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class ESBiomeData {
    public static final ResourceKey<BiomeData> STARLIGHT_FOREST = ESBiomeData.create("starlight_forest");
    public static final ResourceKey<BiomeData> STARLIGHT_DENSE_FOREST = ESBiomeData.create("starlight_dense_forest");
    public static final ResourceKey<BiomeData> STARLIGHT_PERMAFROST_FOREST = ESBiomeData.create("starlight_permafrost_forest");
    public static final ResourceKey<BiomeData> DARK_SWAMP = ESBiomeData.create("dark_swamp");
    public static final ResourceKey<BiomeData> SCARLET_FOREST = ESBiomeData.create("scarlet_forest");
    public static final ResourceKey<BiomeData> TORREYA_FOREST = ESBiomeData.create("torreya_forest");
    public static final ResourceKey<BiomeData> CRYSTALLIZED_DESERT = ESBiomeData.create("crystallized_desert");
    public static final ResourceKey<BiomeData> SHIMMER_RIVER = ESBiomeData.create("shimmer_river");
    public static final ResourceKey<BiomeData> ETHER_RIVER = ESBiomeData.create("ether_river");
    public static final ResourceKey<BiomeData> SHIMMER_RIVER_TRANSITION = ESBiomeData.create("shimmer_river_transition");
    public static final ResourceKey<BiomeData> STARLIT_SEA = ESBiomeData.create("starlit_sea");
    public static final ResourceKey<BiomeData> SPIRAL_KELP_FOREST = ESBiomeData.create("spiral_kelp_forest");
    public static final ResourceKey<BiomeData> LUSH_SHALLOW_SEA = ESBiomeData.create("lush_shallow_sea");
    public static final ResourceKey<BiomeData> THE_ABYSS = ESBiomeData.create("the_abyss");
    public static final ResourceKey<BiomeData> THE_ABYSS_TRANSITION = ESBiomeData.create("the_abyss_transition");
    public static final ResourceKey<BiomeData> WARM_SHORE = ESBiomeData.create("warm_shore");

    public static void bootstrap(BootstrapContext<BiomeData> context) {
        HolderGetter biomeHolderGetter = context.lookup(Registries.BIOME);
        context.register(STARLIGHT_FOREST, (Object)new BiomeData.Builder((Holder<Biome>)biomeHolderGetter.getOrThrow(ESBiomes.STARLIGHT_FOREST), 61, 10).withTemperatures(BiomeData.Temperature.NEUTRAL, BiomeData.Temperature.HOT, BiomeData.Temperature.COLD).build());
        context.register(STARLIGHT_DENSE_FOREST, (Object)new BiomeData.Builder((Holder<Biome>)biomeHolderGetter.getOrThrow(ESBiomes.STARLIGHT_DENSE_FOREST), 61, 10).withTemperatures(BiomeData.Temperature.NEUTRAL, BiomeData.Temperature.HOT, BiomeData.Temperature.COLD).build());
        context.register(DARK_SWAMP, (Object)new BiomeData.Builder((Holder<Biome>)biomeHolderGetter.getOrThrow(ESBiomes.DARK_SWAMP), 61, 5).withTemperatures(BiomeData.Temperature.NEUTRAL, BiomeData.Temperature.HOT).build());
        context.register(STARLIGHT_PERMAFROST_FOREST, (Object)new BiomeData.Builder((Holder<Biome>)biomeHolderGetter.getOrThrow(ESBiomes.STARLIGHT_PERMAFROST_FOREST), 110, 40).withTemperatures(BiomeData.Temperature.COLD, BiomeData.Temperature.COLD_EXTREME).hasBeaches(false).hasRivers(false).build());
        context.register(SCARLET_FOREST, (Object)new BiomeData.Builder((Holder<Biome>)biomeHolderGetter.getOrThrow(ESBiomes.SCARLET_FOREST), 63, 12).withTemperatures(BiomeData.Temperature.NEUTRAL, BiomeData.Temperature.HOT).build());
        context.register(TORREYA_FOREST, (Object)new BiomeData.Builder((Holder<Biome>)biomeHolderGetter.getOrThrow(ESBiomes.TORREYA_FOREST), 63, 12).build());
        context.register(CRYSTALLIZED_DESERT, (Object)new BiomeData.Builder((Holder<Biome>)biomeHolderGetter.getOrThrow(ESBiomes.CRYSTALLIZED_DESERT), 60, 9).withTemperatures(BiomeData.Temperature.HOT, BiomeData.Temperature.HOT_EXTREME).hasRivers(false).build());
        context.register(SHIMMER_RIVER, (Object)new BiomeData.Builder((Holder<Biome>)biomeHolderGetter.getOrThrow(ESBiomes.SHIMMER_RIVER), 40, 3).build());
        context.register(SHIMMER_RIVER_TRANSITION, (Object)new BiomeData.Builder((Holder<Biome>)biomeHolderGetter.getOrThrow(ESBiomes.SHIMMER_RIVER), 45, 3).build());
        context.register(ETHER_RIVER, (Object)new BiomeData.Builder((Holder<Biome>)biomeHolderGetter.getOrThrow(ESBiomes.ETHER_RIVER), 45, 3).withFluid(ESBlocks.ETHER.asHolder()).build());
        context.register(STARLIT_SEA, (Object)new BiomeData.Builder((Holder<Biome>)biomeHolderGetter.getOrThrow(ESBiomes.STARLIT_SEA), 30, 5).fullRangeTemperatures().isOcean(true).build());
        context.register(SPIRAL_KELP_FOREST, (Object)new BiomeData.Builder((Holder<Biome>)biomeHolderGetter.getOrThrow(ESBiomes.SPIRAL_KELP_FOREST), 25, 8).withTemperatures(BiomeData.Temperature.COLD, BiomeData.Temperature.NEUTRAL, BiomeData.Temperature.HOT).isOcean(true).build());
        context.register(LUSH_SHALLOW_SEA, (Object)new BiomeData.Builder((Holder<Biome>)biomeHolderGetter.getOrThrow(ESBiomes.LUSH_SHALLOW_SEA), 32, 4).withTemperatures(BiomeData.Temperature.HOT, BiomeData.Temperature.HOT_EXTREME).isOcean(true).build());
        context.register(THE_ABYSS, (Object)new BiomeData.Builder((Holder<Biome>)biomeHolderGetter.getOrThrow(ESBiomes.THE_ABYSS), -55, 5).isOcean(true).build());
        context.register(THE_ABYSS_TRANSITION, (Object)new BiomeData.Builder((Holder<Biome>)biomeHolderGetter.getOrThrow(ESBiomes.THE_ABYSS), -40, 3).isOcean(true).build());
        context.register(WARM_SHORE, (Object)new BiomeData.Builder((Holder<Biome>)biomeHolderGetter.getOrThrow(ESBiomes.WARM_SHORE), 55, 4).build());
    }

    public static ResourceKey<BiomeData> create(String name) {
        return ResourceKey.create(ESRegistries.BIOME_DATA, (ResourceLocation)EternalStarlight.id(name));
    }
}

