/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.animation.AnimatedEntityModel;
import cn.leolezury.eternalstarlight.common.client.model.animation.definition.AuroraDeerAnimation;
import cn.leolezury.eternalstarlight.common.entity.living.animal.AuroraDeer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AuroraDeerModel<T extends AuroraDeer>
extends AnimatedEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("aurora_deer"), "main");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart leftAntler;
    private final ModelPart rightAntler;

    public AuroraDeerModel(ModelPart root) {
        this.root = root.getChild("root");
        this.head = root.getChild("root").getChild("body").getChild("neck").getChild("head");
        this.leftAntler = this.head.getChild("left_antler");
        this.rightAntler = this.head.getChild("right_antler");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 37).addBox(-4.0f, -4.0f, -8.0f, 8.0f, 8.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-14.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 21).addBox(-3.0f, -10.0f, -2.0f, 6.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)-8.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -5.75f, -5.0f, 6.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 14).addBox(-1.5f, -2.75f, -9.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-10.25f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(14, 17).addBox(0.0f, -1.5f, 0.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(22, 17).addBox(0.0f, 0.5f, 0.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-3.25f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(14, 17).mirror().addBox(-3.0f, -1.5f, 0.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(22, 17).mirror().addBox(-2.0f, 0.5f, 0.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.0f, (float)-3.25f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        head.addOrReplaceChild("left_antler", CubeListBuilder.create().texOffs(28, 6).addBox(-2.0f, -5.0f, -2.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(36, 6).addBox(-2.0f, -4.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(44, 5).addBox(-2.0f, -4.0f, 2.0f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(54, 6).addBox(-2.0f, -7.0f, 3.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(28, 13).addBox(-2.0f, -9.0f, -2.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(46, 13).addBox(-2.0f, -10.0f, -4.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-4.75f, (float)2.0f, (float)-0.2138f, (float)0.0f, (float)0.2138f));
        head.addOrReplaceChild("right_antler", CubeListBuilder.create().texOffs(28, 6).mirror().addBox(0.0f, -5.0f, -2.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(36, 6).mirror().addBox(0.0f, -4.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(44, 5).mirror().addBox(0.0f, -4.0f, 2.0f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(54, 6).mirror().addBox(0.0f, -7.0f, 3.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(28, 13).mirror().addBox(0.0f, -9.0f, -2.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(46, 13).mirror().addBox(0.0f, -10.0f, -4.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.0f, (float)-4.75f, (float)2.0f, (float)-0.2138f, (float)0.0f, (float)-0.2138f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(20, 21).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)8.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(24, 23).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)-10.0f, (float)-6.0f));
        root.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(24, 23).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.5f, (float)-10.0f, (float)-6.0f));
        root.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(40, 21).addBox(-2.25f, -4.0f, -2.5f, 5.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(48, 49).addBox(-2.25f, 4.0f, -0.5f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.25f, (float)-12.0f, (float)5.5f));
        root.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(40, 21).mirror().addBox(-2.75f, -4.0f, -2.5f, 5.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(48, 49).mirror().addBox(-1.75f, 4.0f, -0.5f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.25f, (float)-12.0f, (float)5.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        if (this.young) {
            this.root.xScale = 0.6f;
            this.root.yScale = 0.6f;
            this.root.zScale = 0.6f;
            this.head.xScale = 1.67f;
            this.head.yScale = 1.67f;
            this.head.zScale = 1.67f;
        }
        this.leftAntler.visible = ((AuroraDeer)entity).hasLeftAntler();
        this.rightAntler.visible = ((AuroraDeer)entity).hasRightAntler();
        this.animate(((AuroraDeer)entity).idleAnimationState, AuroraDeerAnimation.IDLE, ageInTicks);
        this.animateWalk(AuroraDeerAnimation.WALK, limbSwing, limbSwingAmount, this.young ? 3.0f : 5.0f, 1.0f);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }
}

