/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.animation;

import cn.leolezury.eternalstarlight.common.client.model.animation.ESKeyframeAnimations;
import java.util.Optional;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.AnimationState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public interface AnimatedModel {
    public static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

    default public void animate(AnimationState state, AnimationDefinition definition, float tickCount) {
        this.animate(state, definition, tickCount, 1.0f, 1.0f);
    }

    default public void animate(AnimationState state, AnimationDefinition definition, float tickCount, float speed, float scale) {
        state.updateTime(tickCount, speed);
        state.ifStarted(animState -> ESKeyframeAnimations.animate(this, definition, animState.getAccumulatedTime(), scale, ANIMATION_VECTOR_CACHE));
    }

    default public void animateWalk(AnimationDefinition definition, float swing, float swingAmount, float speed, float scale) {
        long accumulatedTime = (long)(swing * 50.0f * speed);
        float interpolationScale = Math.min(swingAmount * scale, 1.0f);
        ESKeyframeAnimations.animate(this, definition, accumulatedTime, interpolationScale, ANIMATION_VECTOR_CACHE);
    }

    public ModelPart root();

    default public Optional<ModelPart> getAnyDescendantWithName(String name) {
        return name.equals("root") ? Optional.of(this.root()) : this.root().getAllParts().filter(part -> part.hasChild(name)).findFirst().map(part -> part.getChild(name));
    }
}

