/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.ui.widgets;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2f;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.ui.widgets.IPostDraw;
import tv.soaryn.xycraft.core.ui.widgets.IPreDraw;
import tv.soaryn.xycraft.core.ui.widgets.MutableRectangle;
import tv.soaryn.xycraft.core.ui.widgets.callbacks.IClickCallback;
import tv.soaryn.xycraft.core.ui.widgets.callbacks.IContainerTickCallback;
import tv.soaryn.xycraft.core.ui.widgets.callbacks.IDragCallback;
import tv.soaryn.xycraft.core.ui.widgets.callbacks.IRenderTickCallback;
import tv.soaryn.xycraft.core.ui.widgets.callbacks.IScrollCallback;
import tv.soaryn.xycraft.core.ui.widgets.callbacks.ITooltipCallback;

public abstract class DrawableWidget<T extends DrawableWidget<T>> {
    public final MutableRectangle Dimensions = new MutableRectangle(0.0f, 0.0f, 1.0f, 1.0f);
    public int Color = -1;
    public final Vector2f Velocity = new Vector2f();
    public final Vector2f Acceleration = new Vector2f();
    public DrawableWidget<?> Parent = null;
    public boolean Visible = true;
    public final ObjectArrayList<DrawableWidget<?>> Children = new ObjectArrayList();
    private ITooltipCallback<T> _toolTipCallback = null;
    private IClickCallback<T> _clickCallBack = null;
    private IScrollCallback<T> _scrollCallback = null;
    private IRenderTickCallback<T> _renderTickCallback = null;
    private IContainerTickCallback<T> _containerTickCallback = null;
    private IDragCallback<T> _dragCallback = null;
    private IPreDraw<T> _preDrawCallback = null;
    private IPostDraw<T> _postDrawCallback = null;
    private boolean _isDragStarted = false;
    private boolean _isDragging = false;

    @NotNull
    private T self() {
        return (T)this;
    }

    public T fillParent() {
        if (this.Parent == null) {
            XyCore.Logger.warn(String.valueOf(this) + "tried to fill to parent, but it was null, this should not happen in production!");
            return this.self();
        }
        this.dimensions(0.0f, 0.0f, this.Parent.Dimensions.width, this.Parent.Dimensions.height);
        return this.self();
    }

    public T fillParentHorizontal() {
        if (this.Parent == null) {
            XyCore.Logger.warn(String.valueOf(this) + "tried to fill to parent, but it was null, this should not happen in production!");
            return this.self();
        }
        this.dimensions(0.0f, this.Dimensions.y, this.Parent.Dimensions.width, this.Dimensions.height);
        return this.self();
    }

    public T fillParentVertical() {
        if (this.Parent == null) {
            XyCore.Logger.warn(String.valueOf(this) + "tried to fill to parent, but it was null, this should not happen in production!");
            return this.self();
        }
        this.dimensions(this.Dimensions.x, 0.0f, this.Dimensions.width, this.Parent.Dimensions.height);
        return this.self();
    }

    public T dimensions(float x, float y, float width, float height) {
        this.Dimensions.x = x;
        this.Dimensions.y = y;
        this.Dimensions.width = width;
        this.Dimensions.height = height;
        return this.self();
    }

    public T move(float x, float y) {
        return this.dimensions(this.Dimensions.x + x, this.Dimensions.y + y, this.Dimensions.width, this.Dimensions.height);
    }

    public T offsetSize(float x, float y) {
        return this.dimensions(this.Dimensions.x, this.Dimensions.y, this.Dimensions.width + x, this.Dimensions.height + y);
    }

    public T clamp(float minX, float maxX, float minY, float maxY) {
        return this.dimensions(Mth.clamp((float)this.Dimensions.x, (float)minX, (float)maxX), Mth.clamp((float)this.Dimensions.y, (float)minY, (float)maxY), this.Dimensions.width, this.Dimensions.height);
    }

    public T scale(float x, float y) {
        float deltaX = this.Dimensions.width - this.Dimensions.width * x;
        float deltaY = this.Dimensions.height - this.Dimensions.height * y;
        this.dimensions(this.Dimensions.x + deltaX / 2.0f, this.Dimensions.y + deltaY / 2.0f, this.Dimensions.width - deltaX, this.Dimensions.height - deltaY);
        return this.self();
    }

    public T color(int color) {
        this.Color = color;
        return this.self();
    }

    public T parent(DrawableWidget<?> parent) {
        if (this.Parent != null) {
            this.Parent.Children.remove((Object)this);
        }
        this.Parent = parent;
        if (!this.Parent.Children.contains((Object)this)) {
            this.Parent.Children.add((Object)this);
        }
        return this.self();
    }

    public T addChild(DrawableWidget<?> child) {
        this.Children.add(child);
        if (child.Parent != null) {
            child.Parent.Children.remove((Object)this);
        }
        child.Parent = this;
        return this.self();
    }

    public <W extends DrawableWidget<W>> T addChild(Supplier<W> childSupplier, Consumer<W> childHandler) {
        DrawableWidget child = (DrawableWidget)childSupplier.get();
        this.Children.add((Object)child);
        if (child.Parent != null) {
            child.Parent.Children.remove((Object)this);
        }
        child.Parent = this;
        childHandler.accept(child);
        return this.self();
    }

    public T onToolTip(ITooltipCallback<T> callback) {
        this._toolTipCallback = callback;
        return this.self();
    }

    public T onClick(IClickCallback<T> callback) {
        this._clickCallBack = callback;
        return this.self();
    }

    public T onDrag(IDragCallback<T> callback) {
        this._dragCallback = callback;
        return this.self();
    }

    public T onPreDraw(IPreDraw<T> callback) {
        this._preDrawCallback = callback;
        return this.self();
    }

    public T onPostDraw(IPostDraw<T> callback) {
        this._postDrawCallback = callback;
        return this.self();
    }

    public T onScroll(IScrollCallback<T> callback) {
        this._scrollCallback = callback;
        return this.self();
    }

    public T onRenderTick(IRenderTickCallback<T> callback) {
        this._renderTickCallback = callback;
        return this.self();
    }

    public T onContainerTick(IContainerTickCallback<T> callback) {
        this._containerTickCallback = callback;
        return this.self();
    }

    public boolean contains(double mouseX, double mouseY) {
        return this.Dimensions.contains((float)mouseX, (float)mouseY);
    }

    public void appendToolTips(double mouseX, double mouseY, List<Component> tooltip) {
        this.Children.forEach(drawableWidget -> drawableWidget.appendToolTips(mouseX - (double)this.Dimensions.x, mouseY - (double)this.Dimensions.y, tooltip));
        if (this._toolTipCallback == null) {
            return;
        }
        if (!this.contains(mouseX, mouseY)) {
            return;
        }
        this._toolTipCallback.onTooltip(this.self(), mouseX, mouseY, tooltip);
    }

    public boolean mouseDown(double mouseX, double mouseY, int button) {
        boolean clickHandled = false;
        for (DrawableWidget drawableWidget : this.Children) {
            if (!drawableWidget.mouseDown(mouseX - (double)this.Dimensions.x, mouseY - (double)this.Dimensions.y, button)) continue;
            clickHandled = true;
        }
        if (!this.contains(mouseX, mouseY)) {
            return clickHandled;
        }
        this._isDragStarted = true;
        if (this._clickCallBack == null) {
            return clickHandled;
        }
        return this._clickCallBack.onClick(this.self(), mouseX, mouseY, button, IClickCallback.Action.Down) || clickHandled;
    }

    public boolean mouseUp(double mouseX, double mouseY, int button) {
        boolean releaseHandled = false;
        for (DrawableWidget drawableWidget : this.Children) {
            if (!drawableWidget.mouseUp(mouseX - (double)this.Dimensions.x, mouseY - (double)this.Dimensions.y, button)) continue;
            releaseHandled = true;
        }
        this._isDragging = false;
        if (!this._isDragStarted && !this.contains(mouseX, mouseY)) {
            return releaseHandled;
        }
        this._isDragStarted = false;
        if (this._clickCallBack == null) {
            return releaseHandled;
        }
        return this._clickCallBack.onClick(this.self(), mouseX, mouseY, button, IClickCallback.Action.Up) || releaseHandled;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        boolean scrollHandled = false;
        for (DrawableWidget drawableWidget : this.Children) {
            if (!drawableWidget.mouseScrolled(mouseX - (double)this.Dimensions.x, mouseY - (double)this.Dimensions.y, deltaX, deltaY)) continue;
            scrollHandled = true;
        }
        if (this._scrollCallback == null || !this.contains(mouseX, mouseY)) {
            return scrollHandled;
        }
        return this._scrollCallback.onScroll(this.self(), mouseX, mouseY, deltaX, deltaY) || scrollHandled;
    }

    public void renderTick(@NotNull GuiGraphics graphics, float x, float y, double mouseX, double mouseY, int depth, float time, float partialTick) {
        this.Children.forEach(widget -> widget.renderTick(graphics, this.Dimensions.x + x, this.Dimensions.y + y, mouseX - (double)this.Dimensions.x, mouseY - (double)this.Dimensions.y, depth + 1, time, partialTick));
        if (this._renderTickCallback == null) {
            return;
        }
        this._renderTickCallback.process(this.self(), graphics, x, y, mouseX, mouseY, depth, time, partialTick);
    }

    public void containerTick(float time) {
        this.Children.forEach(widget -> widget.containerTick(time));
        if (this._containerTickCallback == null) {
            return;
        }
        this._containerTickCallback.process(this.self(), time);
    }

    public boolean drag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        for (DrawableWidget drawableWidget : this.Children) {
            if (!drawableWidget.drag(mouseX - (double)this.Dimensions.x, mouseY - (double)this.Dimensions.y, button, deltaX, deltaY)) continue;
            return true;
        }
        if (this._dragCallback == null) {
            return false;
        }
        if (this._dragCallback.onDrag(this.self(), mouseX, mouseY, button, deltaX, deltaY, this._isDragStarted)) {
            this._isDragging = true;
            return true;
        }
        return false;
    }

    protected void drawPre(GuiGraphics graphics, float x, float y, double mouseX, double mouseY, int depth) {
        if (this._preDrawCallback != null) {
            this._preDrawCallback.draw(this.self(), graphics, x, y, mouseX, mouseY, depth);
        }
    }

    protected void drawPost(GuiGraphics graphics, float x, float y, double mouseX, double mouseY, int depth) {
        if (this._postDrawCallback != null) {
            this._postDrawCallback.draw(this.self(), graphics, x, y, mouseX, mouseY, depth);
        }
    }

    protected abstract void drawWidget(GuiGraphics var1, float var2, float var3, double var4, double var6, int var8);

    public void draw(GuiGraphics graphics, float x, float y, double mouseX, double mouseY, int depth) {
        if (!this.Visible) {
            return;
        }
        graphics.pose().pushPose();
        this.drawPre(graphics, x, y, mouseX, mouseY, depth);
        this.Children.forEach(drawableWidget -> drawableWidget.draw(graphics, this.Dimensions.x + x, this.Dimensions.y + y, mouseX - (double)this.Dimensions.x, mouseY - (double)this.Dimensions.y, depth + 1));
        this.drawWidget(graphics, x, y, mouseX, mouseY, depth);
        this.drawPost(graphics, x, y, mouseX, mouseY, depth);
        graphics.pose().popPose();
    }

    public boolean isDragging() {
        return this._isDragging;
    }
}

