/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.blocks;

import com.mojang.datafixers.types.Type;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XyBlockEntity
extends BlockEntity {
    private static final Type<?> DefaultFixer = null;
    private final boolean _needsUpdatePackets;
    private final List<AttachmentType<?>> _syncedAttachments;
    private boolean _needsModelRequest;

    public XyBlockEntity(BlockEntityType blockEntityType, BlockPos pos, BlockState state, AttachmentType<?> ... attachmentsToSync) {
        super(blockEntityType, pos, state);
        this._needsUpdatePackets = attachmentsToSync.length > 0;
        this._syncedAttachments = List.of(attachmentsToSync);
    }

    public void needsModelRequest() {
        this._needsModelRequest = true;
    }

    public static <T extends XyBlockEntity> BlockEntityType<T> supplier(BlockEntityType.BlockEntitySupplier<T> factory, Block block) {
        return new BlockEntityType(factory, Set.of(block), DefaultFixer);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return this._needsUpdatePackets ? ClientboundBlockEntityDataPacket.create((BlockEntity)this) : super.getUpdatePacket();
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        CompoundTag tag = this.serializeAttachments(lookupProvider);
        CompoundTag newTag = super.getUpdateTag(lookupProvider);
        if (tag == null) {
            return newTag;
        }
        for (AttachmentType<?> attachment : this._syncedAttachments) {
            String key;
            Tag value;
            ResourceLocation typeKey = NeoForgeRegistries.ATTACHMENT_TYPES.getKey(attachment);
            if (typeKey == null || (value = tag.get(key = typeKey.toString())) == null) continue;
            newTag.put(key, value);
        }
        return newTag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        if (!this._syncedAttachments.isEmpty()) {
            this.deserializeAttachments(lookupProvider, tag);
        }
        if (this._needsModelRequest) {
            this.requestModelDataUpdate();
        }
    }

    public void onDataPacket(@NotNull Connection connection, @NotNull ClientboundBlockEntityDataPacket packet, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        Level level;
        super.onDataPacket(connection, packet, lookupProvider);
        if (!this._needsUpdatePackets) {
            return;
        }
        CompoundTag tag = packet.getTag();
        if (!tag.isEmpty()) {
            this.deserializeAttachments(lookupProvider, tag);
        }
        if ((level = this.getLevel()) == null) {
            return;
        }
        if (this._needsModelRequest) {
            this.requestModelDataUpdate();
        }
        level.markAndNotifyBlock(this.getBlockPos(), level.getChunkAt(this.getBlockPos()), this.getBlockState(), this.getBlockState(), 3, 512);
    }

    public static abstract class WithMenu
    extends XyBlockEntity
    implements MenuProvider {
        private final Component displayName;

        public WithMenu(BlockEntityType blockEntityType, String displayKey, BlockPos pos, BlockState state, AttachmentType<?> ... attachmentsToSync) {
            super(blockEntityType, pos, state, attachmentsToSync);
            this.displayName = Component.translatable((String)displayKey);
        }

        @NotNull
        public Component getDisplayName() {
            return this.displayName;
        }
    }
}

