/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.extradisks;

import com.refinedmods.refinedstorage.common.storage.StorageContainerUpgradeRecipe;
import com.refinedmods.refinedstorage.common.storage.StorageContainerUpgradeRecipeSerializer;
import com.refinedmods.refinedstorage.common.storage.StorageVariant;
import com.refinedmods.refinedstorage.neoforge.api.RefinedStorageNeoForgeApi;
import de.melanx.extradisks.ModConfig;
import de.melanx.extradisks.Registration;
import de.melanx.extradisks.content.chemical.ExtraChemicalStorageVariant;
import de.melanx.extradisks.content.fluid.ExtraFluidStorageVariant;
import de.melanx.extradisks.content.item.ExtraItemStorageVariant;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="extradisks")
public final class ExtraDisks {
    public static final String MODID = "extradisks";
    public static final Logger LOGGER = LoggerFactory.getLogger(ExtraDisks.class);

    public ExtraDisks(IEventBus modBus, ModContainer container) {
        Registration.init(modBus);
        modBus.addListener(Registration::registerExtras);
        modBus.addListener(ExtraDisks::registerCapabilities);
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ModConfig.CONFIG);
        DeferredRegister recipeSerializerRegistry = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)MODID);
        ExtraDisks.registerRecipeSerializers(recipeSerializerRegistry);
        recipeSerializerRegistry.register(modBus);
    }

    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        for (ExtraItemStorageVariant extraItemStorageVariant : ExtraItemStorageVariant.values()) {
            event.registerBlockEntity(RefinedStorageNeoForgeApi.INSTANCE.getNetworkNodeContainerProviderCapability(), (BlockEntityType)Registration.ITEM_STORAGE_TILE.get((Object)extraItemStorageVariant).get(), (be, side) -> be.getContainerProvider());
        }
        for (Enum enum_ : ExtraFluidStorageVariant.values()) {
            event.registerBlockEntity(RefinedStorageNeoForgeApi.INSTANCE.getNetworkNodeContainerProviderCapability(), (BlockEntityType)Registration.FLUID_STORAGE_TILE.get(enum_).get(), (be, side) -> be.getContainerProvider());
        }
    }

    private static void registerRecipeSerializers(DeferredRegister<RecipeSerializer<?>> registry) {
        registry.register("item_storage_disk_upgrade", () -> new StorageContainerUpgradeRecipeSerializer((Enum[])ExtraItemStorageVariant.values(), to -> new StorageContainerUpgradeRecipe((StorageVariant[])ExtraItemStorageVariant.values(), (StorageVariant)to, Registration.ITEM_STORAGE_DISK::get)));
        registry.register("item_storage_block_upgrade", () -> new StorageContainerUpgradeRecipeSerializer((Enum[])ExtraItemStorageVariant.values(), to -> new StorageContainerUpgradeRecipe((StorageVariant[])ExtraItemStorageVariant.values(), (StorageVariant)to, Registration.ITEM_STORAGE_BLOCK::get)));
        registry.register("fluid_storage_disk_upgrade", () -> new StorageContainerUpgradeRecipeSerializer((Enum[])ExtraFluidStorageVariant.values(), to -> new StorageContainerUpgradeRecipe((StorageVariant[])ExtraFluidStorageVariant.values(), (StorageVariant)to, Registration.FLUID_STORAGE_DISK::get)));
        registry.register("fluid_storage_block_upgrade", () -> new StorageContainerUpgradeRecipeSerializer((Enum[])ExtraFluidStorageVariant.values(), to -> new StorageContainerUpgradeRecipe((StorageVariant[])ExtraFluidStorageVariant.values(), (StorageVariant)to, Registration.FLUID_STORAGE_BLOCK::get)));
        registry.register("chemical_storage_disk_upgrade", () -> new StorageContainerUpgradeRecipeSerializer((Enum[])ExtraChemicalStorageVariant.values(), to -> new StorageContainerUpgradeRecipe((StorageVariant[])ExtraChemicalStorageVariant.values(), (StorageVariant)to, Registration.CHEMICAL_STORAGE_DISK::get)));
        registry.register("chemical_storage_block_upgrade", () -> new StorageContainerUpgradeRecipeSerializer((Enum[])ExtraChemicalStorageVariant.values(), to -> new StorageContainerUpgradeRecipe((StorageVariant[])ExtraChemicalStorageVariant.values(), (StorageVariant)to, Registration.CHEMICAL_STORAGE_BLOCK::get)));
    }
}

