/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import net.neoforged.neoforge.event.village.VillageSiegeEvent;
import net.xalcon.torchmaster.events.EventResult;
import net.xalcon.torchmaster.events.EventResultContainer;
import net.xalcon.torchmaster.events.TorchmasterEventHandler;

@EventBusSubscriber(modid="torchmaster")
public class NeoforgeEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onCheckSpawn(MobSpawnEvent.PositionCheck event) {
        EventResultContainer container = new EventResultContainer(switch (event.getResult()) {
            default -> throw new MatchException(null, null);
            case MobSpawnEvent.PositionCheck.Result.DEFAULT -> EventResult.DEFAULT;
            case MobSpawnEvent.PositionCheck.Result.SUCCEED -> EventResult.ALLOW;
            case MobSpawnEvent.PositionCheck.Result.FAIL -> EventResult.DENY;
        });
        MobSpawnType spawnType = event.getSpawnType();
        Mob entity = event.getEntity();
        Vec3 pos = new Vec3(event.getX(), event.getY(), event.getZ());
        TorchmasterEventHandler.onCheckSpawn(spawnType, (Entity)entity, pos, container);
        event.setResult(switch (container.getResult()) {
            default -> throw new MatchException(null, null);
            case EventResult.DEFAULT -> MobSpawnEvent.PositionCheck.Result.DEFAULT;
            case EventResult.ALLOW -> MobSpawnEvent.PositionCheck.Result.SUCCEED;
            case EventResult.DENY -> MobSpawnEvent.PositionCheck.Result.FAIL;
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onDoSpecialSpawn(MobSpawnEvent.PositionCheck event) {
        EventResultContainer container = new EventResultContainer(switch (event.getResult()) {
            default -> throw new MatchException(null, null);
            case MobSpawnEvent.PositionCheck.Result.DEFAULT -> EventResult.DEFAULT;
            case MobSpawnEvent.PositionCheck.Result.SUCCEED -> EventResult.ALLOW;
            case MobSpawnEvent.PositionCheck.Result.FAIL -> EventResult.DENY;
        });
        MobSpawnType spawnType = event.getSpawnType();
        Mob entity = event.getEntity();
        Vec3 pos = new Vec3(event.getX(), event.getY(), event.getZ());
        TorchmasterEventHandler.onCheckSpawn(spawnType, (Entity)entity, pos, container);
        event.setResult(switch (container.getResult()) {
            default -> throw new MatchException(null, null);
            case EventResult.DEFAULT -> MobSpawnEvent.PositionCheck.Result.DEFAULT;
            case EventResult.ALLOW -> MobSpawnEvent.PositionCheck.Result.SUCCEED;
            case EventResult.DENY -> MobSpawnEvent.PositionCheck.Result.FAIL;
        });
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onVillageSiegeEvent(VillageSiegeEvent event) {
        EventResultContainer container = new EventResultContainer(EventResult.DEFAULT);
        TorchmasterEventHandler.onVillageSiege(event.getLevel(), event.getAttemptedSpawnPos(), container);
        if (container.getResult() == EventResult.DENY) {
            event.setCanceled(true);
        }
    }
}

