/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.tile;

import java.util.ArrayList;
import net.mehvahdjukaar.amendments.common.LiquidMixer;
import net.mehvahdjukaar.amendments.common.block.DyeCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.LiquidCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.common.item.DyeBottleItem;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.PotionBottleType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class LiquidCauldronBlockTile
extends BlockEntity
implements IExtraModelDataProvider,
ISoftFluidTankProvider {
    public static final ModelDataKey<ResourceKey<SoftFluid>> FLUID = new ModelDataKey(ResourceKey.class);
    public static final ModelDataKey<Boolean> GLOWING = new ModelDataKey(Boolean.class);
    private final SoftFluidTank fluidTank;
    private boolean hasGlowInk = false;

    public SoftFluidTank makeTank(BlockState blockState) {
        return blockState.getBlock() instanceof DyeCauldronBlock ? this.createCauldronDyeTank() : this.createCauldronLiquidTank();
    }

    private boolean canMixPotions() {
        CommonConfigs.MixingMode config = CommonConfigs.POTION_MIXING.get();
        return config == CommonConfigs.MixingMode.ON || config == CommonConfigs.MixingMode.ONLY_BOILING && (Boolean)this.getBlockState().getValue((Property)LiquidCauldronBlock.BOILING) != false;
    }

    public LiquidCauldronBlockTile(BlockPos blockPos, BlockState blockState) {
        super(ModRegistry.LIQUID_CAULDRON_TILE.get(), blockPos, blockState);
        this.fluidTank = this.makeTank(blockState);
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        builder.with(FLUID, (Object)((ResourceKey)this.fluidTank.getFluid().getHolder().unwrapKey().get()));
        builder.with(GLOWING, (Object)this.hasGlowInk);
    }

    public SoftFluidTank getSoftFluidTank() {
        return this.fluidTank;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.fluidTank.load(tag, registries);
        if (this.level != null && this.level.isClientSide) {
            this.fluidTank.refreshTintCache();
            this.requestModelReload();
        }
        this.hasGlowInk = tag.getBoolean("glow_ink");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.fluidTank.save(tag, registries);
        if (this.hasGlowInk) {
            tag.putBoolean("glow_ink", true);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void setChanged() {
        if (this.level == null) {
            return;
        }
        this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
        BlockState state = this.getBlockState();
        Block block = state.getBlock();
        if (block instanceof ModCauldronBlock) {
            ModCauldronBlock cb = (ModCauldronBlock)block;
            state = cb.updateStateOnFluidChange(state, this.level, this.worldPosition, this.fluidTank.getFluid());
        }
        if (state != this.getBlockState()) {
            this.level.setBlockAndUpdate(this.worldPosition, state);
        }
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), state, 2);
        super.setChanged();
    }

    public boolean interactWithPlayerItem(Player player, InteractionHand hand, ItemStack stack) {
        if (this.fluidTank.interactWithPlayer(player, hand, this.level, this.worldPosition)) {
            this.level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, this.worldPosition);
            this.setChanged();
            this.maybeSendPotionMixMessage(this.getSoftFluidTank().getFluid(), player);
            return true;
        }
        return false;
    }

    public void consumeOneLayer() {
        this.fluidTank.getFluid().shrink(1);
        this.setChanged();
    }

    public void maybeSendPotionMixMessage(SoftFluidStack stack, Player player) {
        ArrayList<MobEffectInstance> potionEffects;
        int potionEffectAmount;
        if (stack.is(MLBuiltinSoftFluids.POTION) && (potionEffectAmount = (potionEffects = LiquidCauldronBlock.getAllPotionEffects(stack)).size()) == CommonConfigs.POTION_MIXING_LIMIT.get()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.amendments.cauldron"), true);
        }
    }

    public SoftFluidTank createCauldronLiquidTank() {
        return new SoftFluidTank(PlatHelper.getPlatform().isFabric() ? 3 : 4){

            public boolean isFluidCompatible(SoftFluidStack fluidStack) {
                if (fluidStack.is(MLBuiltinSoftFluids.WATER)) {
                    return false;
                }
                if (LiquidCauldronBlockTile.this.canMixPotions() && fluidStack.is(MLBuiltinSoftFluids.POTION) && fluidStack.is(this.getFluid().getHolder())) {
                    return this.fluidStack.getOrDefault((DataComponentType)MoonlightRegistry.BOTTLE_TYPE.get(), (Object)PotionBottleType.REGULAR) == fluidStack.getOrDefault((DataComponentType)MoonlightRegistry.BOTTLE_TYPE.get(), (Object)PotionBottleType.REGULAR);
                }
                return super.isFluidCompatible(fluidStack);
            }

            protected void addFluidOntoExisting(SoftFluidStack incoming) {
                SoftFluidStack newStack;
                if (LiquidCauldronBlockTile.this.canMixPotions() && incoming.is(MLBuiltinSoftFluids.POTION) && (newStack = LiquidMixer.mixPotions(this.fluidStack, incoming)) != null) {
                    this.setFluid(newStack);
                    this.needsColorRefresh = true;
                }
                super.addFluidOntoExisting(incoming);
            }
        };
    }

    public SoftFluidTank createCauldronDyeTank() {
        return new SoftFluidTank(this, 3){

            public boolean isFluidCompatible(SoftFluidStack fluidStack) {
                if (fluidStack.is(ModRegistry.DYE_SOFT_FLUID) && fluidStack.is(this.getFluid().getHolder())) {
                    return true;
                }
                return super.isFluidCompatible(fluidStack);
            }

            protected void addFluidOntoExisting(SoftFluidStack fluidStack) {
                SoftFluidStack mixed;
                if (fluidStack.is(ModRegistry.DYE_SOFT_FLUID) && (mixed = LiquidMixer.mixDye(this.fluidStack, fluidStack)) != null) {
                    this.setFluid(mixed);
                    this.needsColorRefresh = true;
                }
                super.addFluidOntoExisting(fluidStack);
            }

            @Nullable
            public ItemStack interactWithItem(ItemStack stack, Level world, @Nullable BlockPos pos, boolean simulate) {
                Item item = stack.getItem();
                if (item instanceof DyeItem) {
                    DyeItem di = (DyeItem)item;
                    if (!simulate) {
                        this.addDye(di, world, pos);
                    }
                    return ItemStack.EMPTY;
                }
                return super.interactWithItem(stack, world, pos, simulate);
            }

            private void addDye(DyeItem dyeItem, Level world, @Nullable BlockPos pos) {
                SoftFluidStack fluid = this.getFluid();
                if (!world.isClientSide()) {
                    int count = fluid.getCount();
                    if (count == 3) {
                        fluid.setCount(2);
                    }
                    SoftFluidStack dummyStack = DyeBottleItem.createFluidStack(dyeItem.getDyeColor(), 1, world);
                    LiquidMixer.mixDye(fluid, dummyStack);
                    fluid.setCount(count);
                }
                if (pos != null) {
                    world.playSound(null, pos, SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    world.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.3f);
                }
            }
        };
    }

    public boolean isGlowing() {
        return this.hasGlowInk;
    }

    public void setGlowing(boolean b) {
        this.hasGlowInk = b;
        this.setChanged();
    }
}

