/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.treetap.common.block.entity;

import cy.jdkdigital.treetap.TreeTap;
import cy.jdkdigital.treetap.common.recipe.TapExtractRecipe;
import cy.jdkdigital.treetap.util.ProgressFluidTank;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class SapCollectorBlockEntity
extends BlockEntity {
    public int progress = 0;
    public RecipeHolder<TapExtractRecipe> currentRecipe;
    private IItemHandlerModifiable inventoryHandler = new ItemStackHandler(1){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack out = super.extractItem(slot, amount, simulate);
            if (!simulate && this.getStackInSlot(slot).isEmpty()) {
                SapCollectorBlockEntity.this.progress = 0;
            }
            return out;
        }
    };
    public IFluidHandler fluidHandler = new ProgressFluidTank(1000, this);

    public SapCollectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TreeTap.SAP_COLLECTOR_BLOCK_ENTITY.get(), pos, state);
    }

    public void setCurrentRecipe(RecipeHolder<TapExtractRecipe> recipe) {
        IFluidHandlerItem itemCap;
        this.currentRecipe = recipe;
        if (this.currentRecipe != null && (itemCap = (IFluidHandlerItem)((TapExtractRecipe)this.currentRecipe.value()).getResultItem(this.getBlockState()).getCapability(Capabilities.FluidHandler.ITEM)) != null) {
            this.fluidHandler = new ProgressFluidTank(1000, this);
            if (this.progress > 0) {
                itemCap.fill(new FluidStack(this.fluidHandler.getFluidInTank(0).getFluid(), (int)((float)this.fluidHandler.getTankCapacity(0) * ((float)this.progress / (float)((TapExtractRecipe)this.currentRecipe.value()).processingTime))), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public void addProgress(int progress) {
        if (this.currentRecipe != null) {
            this.progress += progress;
            IFluidHandlerItem fluidCap = (IFluidHandlerItem)((TapExtractRecipe)this.currentRecipe.value()).getResultItem(this.getBlockState()).getCapability(Capabilities.FluidHandler.ITEM);
            if (fluidCap != null) {
                if (this.fluidHandler.getFluidInTank(0).isEmpty()) {
                    this.fluidHandler.fill(new FluidStack(fluidCap.getFluidInTank(0).getFluid(), (int)(1000.0f * ((float)this.progress / (float)((TapExtractRecipe)this.currentRecipe.value()).processingTime))), IFluidHandler.FluidAction.EXECUTE);
                } else {
                    this.fluidHandler.getFluidInTank(0).setAmount((int)(1000.0f * ((float)this.progress / (float)((TapExtractRecipe)this.currentRecipe.value()).processingTime)));
                }
            } else if (this.progress >= ((TapExtractRecipe)this.currentRecipe.value()).processingTime) {
                this.inventoryHandler.setStackInSlot(0, ((TapExtractRecipe)this.currentRecipe.value()).getResultItem(this.getBlockState()));
            }
        }
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.loadPacketNBT(pTag, pRegistries);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        this.savePacketNBT(pTag, pRegistries);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithId(pRegistries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        this.loadPacketNBT(pkt.getTag(), lookupProvider);
        if (this.level instanceof ClientLevel) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 0);
        }
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.progress = tag.getInt("progress");
        if (tag.contains("recipe") && this.level != null) {
            Optional recipe = this.level.getRecipeManager().byKey(ResourceLocation.parse((String)tag.getString("recipe")));
            recipe.ifPresent(value -> this.setCurrentRecipe((RecipeHolder<TapExtractRecipe>)value));
        }
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        tag.putInt("progress", this.progress);
        if (this.currentRecipe != null) {
            tag.putString("recipe", this.currentRecipe.id().toString());
        }
    }
}

