/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.datagen;

import com.hollingsworth.arsnouveau.setup.registry.BlockRegistryWrapper;
import dev.qther.ars_controle.registry.ACRegistry;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class ACLootProvider
extends LootTableProvider {
    public ACLootProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super(pOutput, (Set)new ObjectOpenHashSet(), List.of(new LootTableProvider.SubProviderEntry(BlockLootTable::new, LootContextParamSets.BLOCK)), registries);
    }

    public static class BlockLootTable
    extends BlockLootSubProvider {
        public List<Block> list = new ArrayList<Block>();

        protected BlockLootTable(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        protected void generate() {
            this.registerDropSelf(ACRegistry.Blocks.WARPING_SPELL_PRISM);
            this.registerDropSelf(ACRegistry.Blocks.SCRYERS_LINKAGE);
            this.registerDropSelf(ACRegistry.Blocks.TEMPORAL_STABILITY_SENSOR);
            this.registerDropSelf(ACRegistry.Blocks.SCROLL_HOLDER);
        }

        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> p_249322_) {
            this.generate();
            ObjectOpenHashSet set = new ObjectOpenHashSet();
            for (Block block : this.list) {
                LootTable.Builder loottable$builder;
                ResourceKey resourcelocation;
                if (!block.isEnabled(this.enabledFeatures) || (resourcelocation = block.getLootTable()) == BuiltInLootTables.EMPTY || !set.add((Object)resourcelocation) || (loottable$builder = (LootTable.Builder)this.map.remove(resourcelocation)) == null) continue;
                p_249322_.accept((ResourceKey<LootTable>)resourcelocation, loottable$builder);
            }
        }

        public void registerDropSelf(BlockRegistryWrapper<? extends Block> block) {
            this.list.add((Block)block.get());
            this.dropSelf((Block)block.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return BuiltInRegistries.BLOCK.stream().filter(block -> BuiltInRegistries.BLOCK.getKey(block).getNamespace().equals("ars_nouveau")).collect(Collectors.toList());
        }
    }
}

