/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.config;

import com.hollingsworth.arsnouveau.common.block.tile.LecternInvWrapper;
import dev.qther.ars_controle.ArsControle;
import dev.qther.ars_controle.config.ConfigHelper;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ACStartupConfig {
    public final ModConfigSpec.ConfigValue<List<? extends String>> SCRYERS_LINKAGE_BLACKLISTED_CAPABILITIES;
    private final List<String> DEFAULT_CLASS_BLACKLIST = List.of(LecternInvWrapper.class.getCanonicalName(), "appeng.api.networking.IInWorldGridNodeHost");
    public final List<Class<?>> SCRYERS_LINKAGE_BLACKLISTED_CLASSES = new ArrayList();
    public static final ACStartupConfig STARTUP;
    public static final ModConfigSpec SPEC;

    ACStartupConfig(ModConfigSpec.Builder builder) {
        ConfigHelper.CategoryBuilder scryersLinkage = new ConfigHelper.CategoryBuilder(builder, "scryers_linkage");
        scryersLinkage.push("Config for Scryer's Linkage");
        this.SCRYERS_LINKAGE_BLACKLISTED_CAPABILITIES = scryersLinkage.makeStringList("blacklisted_capabilities", this.DEFAULT_CLASS_BLACKLIST, LecternInvWrapper.class.getCanonicalName(), s -> {
            try {
                Class.forName(s);
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }, "List of class paths of blacklisted capabilities for Scryer's Linkage");
        scryersLinkage.pop();
    }

    public static void onLoad(ModConfigEvent.Loading event) {
        if (!event.getConfig().getSpec().equals((Object)SPEC)) {
            return;
        }
        ACStartupConfig.STARTUP.SCRYERS_LINKAGE_BLACKLISTED_CLASSES.clear();
        for (String s : (List)ACStartupConfig.STARTUP.SCRYERS_LINKAGE_BLACKLISTED_CAPABILITIES.get()) {
            try {
                Class<?> clazz = Class.forName(s);
                ACStartupConfig.STARTUP.SCRYERS_LINKAGE_BLACKLISTED_CLASSES.add(clazz);
            }
            catch (ClassNotFoundException e) {
                if (ACStartupConfig.STARTUP.DEFAULT_CLASS_BLACKLIST.contains(s)) continue;
                ArsControle.LOGGER.warn("Could not find blacklisted capability class: {}", (Object)s);
            }
        }
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(ACStartupConfig::new);
        STARTUP = (ACStartupConfig)pair.getLeft();
        SPEC = (ModConfigSpec)pair.getRight();
    }
}

