/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.block;

import com.hollingsworth.arsnouveau.common.block.ModBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemporalStabilitySensorBlock
extends ModBlock {
    protected boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return (int)Math.round((double)serverLevel.getServer().getAverageTickTimeNanos() * 15.0 / 50.0 / (double)TimeUtil.NANOSECONDS_PER_MILLISECOND);
        }
        return 0;
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        super.tick(state, level, pos, random);
        level.updateNeighbourForOutputSignal(pos, (Block)this);
        level.scheduleTick(pos, (Block)this, 10, TickPriority.EXTREMELY_HIGH);
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        level.scheduleTick(pos, (Block)this, 10, TickPriority.EXTREMELY_HIGH);
    }
}

