/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.advancements;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import plus.dragons.createdragonsplus.common.CDPCommon;
import plus.dragons.createdragonsplus.common.advancements.criterion.BuiltinTrigger;
import plus.dragons.createdragonsplus.util.CDPCodecs;
import plus.dragons.createdragonsplus.util.ErrorMessages;

public class AdvancementBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<AdvancementBehaviour> TYPE = new BehaviourType(CDPCommon.asResource("advancement").toString());
    protected static final String TYPE_KEY = TYPE.getName();
    protected static final String OWNER_KEY = "Owner";
    protected static final String STATS_COUNTER_KEY = "StatsCounter";
    protected static final Codec<Object2IntMap<Stat<?>>> STATS_COUNTER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CDPCodecs.STAT.forGetter(Pair::getFirst), (App)Codec.INT.fieldOf("count").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of)).listOf().xmap(list -> {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        list.forEach(arg_0 -> AdvancementBehaviour.lambda$static$1((Object2IntMap)map, arg_0));
        return map;
    }, map -> {
        ImmutableList.Builder builder = ImmutableList.builder();
        map.forEach((stat, count) -> builder.add((Object)Pair.of((Object)stat, (Object)count)));
        return builder.build();
    });
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    protected UUID owner;
    protected Object2IntMap<Stat<?>> statsCounter = new Object2IntOpenHashMap();

    public AdvancementBehaviour(SmartBlockEntity be) {
        super(be);
    }

    public static void setPlacedBy(Level level, BlockPos pos, LivingEntity entity) {
        AdvancementBehaviour behaviour = (AdvancementBehaviour)AdvancementBehaviour.get((BlockGetter)level, (BlockPos)pos, TYPE);
        if (behaviour != null && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            behaviour.setOwner(player);
        }
    }

    public void setOwner(@Nullable UUID owner) {
        if (owner != this.owner) {
            this.statsCounter.clear();
        }
        this.owner = owner;
    }

    public void setOwner(ServerPlayer player) {
        if (player instanceof FakePlayer) {
            return;
        }
        this.setOwner(player.getUUID());
    }

    @Nullable
    public ServerPlayer getOwner() {
        if (this.owner == null) {
            return null;
        }
        Player player = this.getWorld().getPlayerByUUID(this.owner);
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            return player2 instanceof FakePlayer ? null : player2;
        }
        return null;
    }

    public void trigger(BuiltinTrigger trigger) {
        ServerPlayer owner = this.getOwner();
        if (owner != null) {
            trigger.trigger(owner);
        }
    }

    public void awardStat(Stat<?> stat, int count) {
        ServerPlayer owner = this.getOwner();
        if (owner == null) {
            if (this.owner != null) {
                this.statsCounter.computeInt(stat, (k, v) -> (v == null ? 0 : v) + count);
            }
            return;
        }
        owner.awardStat(stat, count + this.statsCounter.removeInt(stat));
    }

    public void awardStat(ResourceLocation stat, int count) {
        this.awardStat(Stats.CUSTOM.get((Object)stat), count);
    }

    public void resetStat(Stat<?> stat) {
        this.statsCounter.removeInt(stat);
        ServerPlayer owner = this.getOwner();
        if (owner != null) {
            owner.resetStat(stat);
        }
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        if (clientPacket) {
            return;
        }
        if (!nbt.contains(OWNER_KEY)) {
            this.setOwner((UUID)null);
            return;
        }
        this.setOwner(nbt.getUUID(OWNER_KEY));
        if (!nbt.contains(STATS_COUNTER_KEY)) {
            this.statsCounter.clear();
            return;
        }
        STATS_COUNTER_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get(STATS_COUNTER_KEY)).resultOrPartial(this::errorReading).ifPresent(map -> {
            this.statsCounter = map;
        });
    }

    public void write(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        if (clientPacket) {
            return;
        }
        if (this.owner != null) {
            nbt.putUUID(OWNER_KEY, this.owner);
        }
        if (!this.statsCounter.isEmpty()) {
            STATS_COUNTER_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.statsCounter).resultOrPartial(this::errorWriting).ifPresent(it -> nbt.put(STATS_COUNTER_KEY, it));
        }
    }

    protected void errorReading(String error) {
        error = "Error reading " + ((Object)((Object)this)).getClass().getSimpleName() + " for block entity: " + ErrorMessages.blockEntity((BlockEntity)this.blockEntity) + ", caused by: " + (String)error;
        LOGGER.error((String)error);
    }

    protected void errorWriting(String error) {
        error = "Error writing " + ((Object)((Object)this)).getClass().getSimpleName() + " for block entity: " + ErrorMessages.blockEntity((BlockEntity)this.blockEntity) + ", caused by: " + (String)error;
        LOGGER.error((String)error);
    }

    private static /* synthetic */ void lambda$static$1(Object2IntMap map, Pair entry) {
        map.put((Object)((Stat)entry.getFirst()), ((Integer)entry.getSecond()).intValue());
    }
}

