/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.util;

import dev.shadowsoffire.apotheosis.AdventureConfig;
import dev.shadowsoffire.apotheosis.net.LinkItemToChatPayload;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.PacketDistributor;

public class ItemLinking {
    private static final Object2LongMap<UUID> LAST_LINK_TIMES = new Object2LongOpenHashMap();

    public static void sendHoveredItem() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            Client.sendHoveredItem();
        }
    }

    public static boolean isOnCooldown(UUID id, long gameTime) {
        return LAST_LINK_TIMES.getOrDefault((Object)id, (long)(-AdventureConfig.itemLinkingCooldown)) + (long)AdventureConfig.itemLinkingCooldown >= gameTime;
    }

    public static void startCooldown(UUID id, long gameTime) {
        LAST_LINK_TIMES.put((Object)id, gameTime);
    }

    public static class Client {
        public static void sendHoveredItem() {
            AbstractContainerScreen scn;
            Slot slot;
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof AbstractContainerScreen && (slot = (scn = (AbstractContainerScreen)screen).getSlotUnderMouse()) != null && slot.hasItem()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new LinkItemToChatPayload(scn.getMenu().containerId, slot.index, slot.getItem().getItem()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

