/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.mobs.util;

import com.mojang.serialization.Codec;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;

public enum SurfaceType implements BiPredicate<ServerLevelAccessor, BlockPos>
{
    NEEDS_SKY(BlockAndTintGetter::canSeeSky),
    NEEDS_SURFACE((level, pos) -> pos.getY() >= level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.getX(), pos.getZ())),
    BELOW_SURFACE((level, pos) -> pos.getY() < level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.getX(), pos.getZ())),
    CANNOT_SEE_SKY((level, pos) -> !level.canSeeSky(pos)),
    SURFACE_OUTER_END((level, pos) -> NEEDS_SURFACE.test((ServerLevelAccessor)level, (BlockPos)pos) && (Mth.abs((int)pos.getX()) > 1024 || Mth.abs((int)pos.getZ()) > 1024)),
    ANY((level, pos) -> true),
    NEEDS_SKY_OR_SAME_VERTICAL_SLICE(SurfaceType::skyOrSameVerticalSlice);

    public static final Codec<SurfaceType> CODEC;
    BiPredicate<ServerLevelAccessor, BlockPos> pred;

    private SurfaceType(BiPredicate<ServerLevelAccessor, BlockPos> pred) {
        this.pred = pred;
    }

    @Override
    public boolean test(ServerLevelAccessor t, BlockPos u) {
        return this.pred.test(t, u);
    }

    private static boolean skyOrSameVerticalSlice(ServerLevelAccessor level, BlockPos pos) {
        if (NEEDS_SKY.test(level, pos)) {
            return true;
        }
        Player player = level.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), -1.0, false);
        return Math.abs(player.position().y - (double)pos.getY()) <= 8.0;
    }

    static {
        CODEC = PlaceboCodecs.enumCodec(SurfaceType.class);
    }
}

