/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.mobs.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.loot.AffixLootRegistry;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootController;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.apothic_attributes.modifiers.EquipmentSlotCompat;
import dev.shadowsoffire.placebo.codec.CodecMap;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.json.ChancedEffectInstance;
import dev.shadowsoffire.placebo.json.RandomAttributeModifier;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.systems.gear.GearSet;
import dev.shadowsoffire.placebo.systems.gear.GearSetRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface EntityModifier
extends CodecProvider<EntityModifier> {
    public static final CodecMap<EntityModifier> CODEC = new CodecMap("Apothic Entity Modifier");

    public void apply(Mob var1, GenContext var2);

    @Deprecated(forRemoval=true)
    default public void appendHoverText(Item.TooltipContext ctx, Consumer<MutableComponent> list) {
    }

    public static void initCodecs() {
        EntityModifier.register("mob_effect", EffectModifier.CODEC);
        EntityModifier.register("attribute", AttributeModifier.CODEC);
        EntityModifier.register("gear_set", GearSetModifier.CODEC);
        EntityModifier.register("random_affix_item", RandomAffixItemModifier.CODEC);
    }

    private static void register(String id, Codec<? extends EntityModifier> codec) {
        CODEC.register(Apotheosis.loc(id), codec);
    }

    public record EffectModifier(ChancedEffectInstance effect) implements EntityModifier
    {
        public static Codec<EffectModifier> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ChancedEffectInstance.CONSTANT_CODEC.fieldOf("effect").forGetter(EffectModifier::effect)).apply((Applicative)inst, EffectModifier::new));

        public Codec<? extends EntityModifier> getCodec() {
            return CODEC;
        }

        @Override
        public void apply(Mob mob, GenContext ctx) {
            int duration = mob instanceof Creeper ? 6000 : Integer.MAX_VALUE;
            mob.addEffect(this.effect.createDeterministic(duration));
        }
    }

    public record AttributeModifier(RandomAttributeModifier modifier) implements EntityModifier
    {
        public static Codec<AttributeModifier> CODEC = RandomAttributeModifier.CODEC.xmap(AttributeModifier::new, AttributeModifier::modifier);

        public Codec<? extends EntityModifier> getCodec() {
            return CODEC;
        }

        @Override
        public void apply(Mob mob, GenContext ctx) {
            AttributeInstance inst = mob.getAttribute(this.modifier.attribute());
            if (inst == null) {
                return;
            }
            this.modifier.apply(Apotheosis.loc("rm_ " + mob.getRandom().nextInt()), ctx.rand(), (LivingEntity)mob);
        }
    }

    public record GearSetModifier(List<GearSet.SetPredicate> gearSets) implements EntityModifier
    {
        public static Codec<GearSetModifier> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)GearSet.SetPredicate.CODEC.listOf().fieldOf("valid_gear_sets").forGetter(GearSetModifier::gearSets)).apply((Applicative)inst, GearSetModifier::new));

        public Codec<? extends EntityModifier> getCodec() {
            return CODEC;
        }

        @Override
        public void apply(Mob mob, GenContext ctx) {
            GearSet set = GearSetRegistry.INSTANCE.getRandomSet(ctx.rand(), ctx.luck(), this.gearSets);
            if (set != null) {
                set.apply((LivingEntity)mob);
            }
        }
    }

    public record RandomAffixItemModifier(Set<DynamicHolder<LootRarity>> rarities, Set<DynamicHolder<AffixLootEntry>> entries) implements EntityModifier
    {
        public static Codec<RandomAffixItemModifier> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PlaceboCodecs.setOf((Codec)RarityRegistry.INSTANCE.holderCodec()).optionalFieldOf("rarities", Set.of()).forGetter(a -> a.rarities), (App)PlaceboCodecs.setOf((Codec)AffixLootRegistry.INSTANCE.holderCodec()).optionalFieldOf("entries", Set.of()).forGetter(a -> a.entries)).apply((Applicative)inst, RandomAffixItemModifier::new));

        public RandomAffixItemModifier() {
            this(Set.of(), Set.of());
        }

        public Codec<? extends EntityModifier> getCodec() {
            return CODEC;
        }

        @Override
        public void apply(Mob mob, GenContext ctx) {
            ItemStack stack = LootController.createAffixItemFromPools(this.rarities, this.entries, ctx);
            if (stack.isEmpty()) {
                return;
            }
            stack.set(Apoth.Components.FROM_MOB, (Object)true);
            LootCategory cat = LootCategory.forItem(stack);
            EquipmentSlot slot = Arrays.stream(EquipmentSlot.values()).filter(eSlot -> cat.getSlots().test(EquipmentSlotCompat.fromVanilla((EquipmentSlot)eSlot))).findAny().orElse(EquipmentSlot.MAINHAND);
            mob.setItemSlot(slot, stack);
            mob.setGuaranteedDrop(slot);
        }
    }
}

