/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.mixin;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.util.ApothMiscUtil;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentHelper.class}, remap=false)
public class EnchantmentHelperMixin {
    @Inject(at={@At(value="RETURN")}, method={"getDamageProtection(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/damagesource/DamageSource;)F"}, cancellable=true)
    private static void apoth_getDamageProtection(ServerLevel level, LivingEntity entity, DamageSource source, CallbackInfoReturnable<Float> cir) {
        float prot = cir.getReturnValueF();
        for (ItemStack s : entity.getArmorAndBodyArmorSlots()) {
            prot += SocketHelper.getGems(s).getDamageProtection(source);
            Map<DynamicHolder<Affix>, AffixInstance> affixes = AffixHelper.getAffixes(s);
            for (AffixInstance inst : affixes.values()) {
                prot += inst.getDamageProtection(source);
            }
        }
        cir.setReturnValue((Object)Float.valueOf(prot));
    }

    @Inject(at={@At(value="RETURN")}, method={"modifyDamage(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;F)F"}, cancellable=true)
    private static void apoth_modifyDamage(ServerLevel level, ItemStack tool, Entity entity, DamageSource damageSource, float damage, CallbackInfoReturnable<Float> cir) {
        float dmg = cir.getReturnValueF();
        dmg += SocketHelper.getGems(tool).getDamageBonus(entity);
        Map<DynamicHolder<Affix>, AffixInstance> affixes = AffixHelper.getAffixes(tool);
        for (AffixInstance inst : affixes.values()) {
            dmg += inst.getDamageBonus(entity);
        }
        cir.setReturnValue((Object)Float.valueOf(dmg));
    }

    @Inject(at={@At(value="TAIL")}, method={"doPostAttackEffectsWithItemSource(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;Lnet/minecraft/world/item/ItemStack;)V"})
    private static void apoth_doPostAttackEffectsWithItemSource(ServerLevel level, Entity target, DamageSource damageSource, @Nullable ItemStack itemSource, CallbackInfo ci) {
        Map<DynamicHolder<Affix>, AffixInstance> affixes;
        Entity entity = damageSource.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity user = (LivingEntity)entity;
            for (ItemStack s : user.getAllSlots()) {
                SocketHelper.getGems(s).doPostAttack(user, target);
                affixes = AffixHelper.getAffixes(s);
                for (AffixInstance inst : affixes.values()) {
                    int old = target.invulnerableTime;
                    target.invulnerableTime = 0;
                    inst.doPostAttack(user, target);
                    target.invulnerableTime = old;
                }
            }
        }
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            for (ItemStack s : livingTarget.getAllSlots()) {
                SocketHelper.getGems(s).doPostHurt(livingTarget, damageSource);
                affixes = AffixHelper.getAffixes(s);
                for (AffixInstance inst : affixes.values()) {
                    inst.doPostHurt(livingTarget, damageSource);
                }
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"processDurabilityChange(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/item/ItemStack;I)I"}, cancellable=true)
    private static void apoth_processAffixDurability(ServerLevel level, ItemStack stack, int damage, CallbackInfoReturnable<Integer> cir) {
        if (cir.getReturnValueI() <= 0) {
            return;
        }
        int amount = cir.getReturnValueI();
        double chance = ((Float)stack.getOrDefault(Apoth.Components.DURABILITY_BONUS, (Object)Float.valueOf(0.0f))).floatValue();
        if (stack.has(Apoth.Components.SOCKETED_GEMS)) {
            double socketBonus = SocketHelper.getGems(stack).getDurabilityBonusPercentage().reduce(0.0, ApothMiscUtil::duraProd);
            chance = ApothMiscUtil.duraProd(chance, socketBonus);
        }
        if (stack.has(Apoth.Components.AFFIXES)) {
            double afxBonus = AffixHelper.streamAffixes(stack).mapToDouble(AffixInstance::getDurabilityBonusPercentage).reduce(0.0, ApothMiscUtil::duraProd);
            chance = ApothMiscUtil.duraProd(chance, afxBonus);
        }
        int delta = 1;
        int blocked = 0;
        if (chance < 0.0) {
            delta = -1;
            chance = -chance;
        }
        if (chance > 0.0) {
            for (int i = 0; i < amount; ++i) {
                if (!((double)level.getRandom().nextFloat() <= chance)) continue;
                blocked += delta;
            }
        }
        cir.setReturnValue((Object)(amount - blocked));
    }
}

