/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.loot;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.affix.AffixType;
import dev.shadowsoffire.apotheosis.affix.ItemAffixes;
import dev.shadowsoffire.apotheosis.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.loot.AffixLootRegistry;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.LootRule;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.item.ItemStack;

public class LootController {
    static Random jRand = new Random();

    public static ItemStack createLootItem(ItemStack stack, LootRarity rarity, GenContext ctx) {
        LootCategory cat = LootCategory.forItem(stack);
        if (cat.isNone()) {
            return stack;
        }
        return LootController.createLootItem(stack, cat, rarity, ctx);
    }

    public static ItemStack createLootItem(ItemStack stack, LootCategory cat, LootRarity rarity, GenContext ctx) {
        stack.set(Apoth.Components.AFFIXES, (Object)ItemAffixes.EMPTY);
        AffixHelper.setRarity(stack, rarity);
        for (LootRule rule : rarity.getRules(cat)) {
            rule.execute(stack, rarity, ctx);
        }
        ItemAffixes loaded = (ItemAffixes)stack.getOrDefault(Apoth.Components.AFFIXES, (Object)ItemAffixes.EMPTY);
        if (loaded.size() == 0) {
            return stack;
        }
        ArrayList<Affix> nameList = new ArrayList<Affix>(loaded.size());
        for (DynamicHolder a : loaded.keySet()) {
            nameList.add((Affix)a.get());
        }
        jRand.setSeed(ctx.rand().nextLong());
        Collections.shuffle(nameList, jRand);
        String key = nameList.size() > 1 ? "misc.apotheosis.affix_name.three" : "misc.apotheosis.affix_name.two";
        MutableComponent name = Component.translatable((String)key, (Object[])new Object[]{((Affix)nameList.get(0)).getName(true), "", nameList.size() > 1 ? ((Affix)nameList.get(1)).getName(false) : ""}).withStyle(Style.EMPTY.withColor(rarity.color()).withItalic(Boolean.valueOf(false)));
        AffixHelper.setName(stack, (Component)name);
        stack.remove(Apoth.Components.TOUCHED_BY_MALICE);
        return stack;
    }

    public static ItemStack createRandomLootItem(GenContext ctx, @Nullable LootRarity rarity) {
        AffixLootEntry entry = AffixLootRegistry.INSTANCE.getRandomItem(ctx);
        if (entry == null) {
            return ItemStack.EMPTY;
        }
        if (rarity == null) {
            rarity = LootRarity.random(ctx, entry.rarities());
        }
        return LootController.createLootItem(entry.stack(), entry.getType(), rarity, ctx);
    }

    public static Stream<DynamicHolder<Affix>> getAvailableAffixes(ItemStack stack, LootRarity rarity, AffixType type) {
        LootCategory cat = LootCategory.forItem(stack);
        ItemAffixes current = (ItemAffixes)stack.getOrDefault(Apoth.Components.AFFIXES, (Object)ItemAffixes.EMPTY);
        return AffixHelper.byType(type).stream().filter(a -> ((Affix)a.get()).canApplyTo(stack, cat, rarity)).filter(a -> ((Affix)a.get()).isCompatibleWith(current));
    }

    public static Stream<DynamicHolder<Affix>> getAlternativeAffixes(ItemStack stack, LootRarity rarity, DynamicHolder<Affix> affix) {
        ItemStack copy = stack.copy();
        ItemAffixes fixed = ((ItemAffixes)copy.getOrDefault(Apoth.Components.AFFIXES, (Object)ItemAffixes.EMPTY)).toBuilder().remove(affix).build();
        copy.set(Apoth.Components.AFFIXES, (Object)fixed);
        return LootController.getAvailableAffixes(copy, rarity, ((Affix)affix.get()).definition().type()).filter(a -> !a.equals((Object)affix));
    }

    public static List<WeightedEntry.Wrapper<Affix>> getWeightedAffixes(ItemStack stack, LootRarity rarity, AffixType type, GenContext ctx) {
        return LootController.getAvailableAffixes(stack, rarity, type).map(a -> ((Affix)a.get()).wrap(ctx.tier(), ctx.luck())).toList();
    }

    public static ItemStack createAffixItemFromPools(Set<DynamicHolder<LootRarity>> rarities, Set<DynamicHolder<AffixLootEntry>> entries, GenContext gCtx) {
        ItemStack stack;
        if (entries.isEmpty()) {
            LootRarity selectedRarity = LootRarity.randomFromHolders(gCtx, rarities);
            stack = LootController.createRandomLootItem(gCtx, selectedRarity);
        } else {
            Set resolved = entries.stream().filter(DynamicHolder::isBound).map(DynamicHolder::get).collect(Collectors.toSet());
            Predicate[] predicateArray = new Predicate[1];
            predicateArray[0] = resolved::contains;
            AffixLootEntry entry = (AffixLootEntry)AffixLootRegistry.INSTANCE.getRandomItem(gCtx, predicateArray);
            if (entry == null) {
                return ItemStack.EMPTY;
            }
            LootRarity rarity = rarities.isEmpty() ? LootRarity.random(gCtx, entry.rarities()) : LootRarity.randomFromHolders(gCtx, rarities);
            stack = LootController.createLootItem(entry.stack(), rarity, gCtx);
        }
        return stack;
    }
}

