/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class EquippedItemTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, EquipmentSlot slot, ItemStack stack) {
        this.trigger(player, inst -> inst.matches(slot, stack));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, EquipmentSlotGroup slots, ItemPredicate items) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EquipmentSlotGroup.CODEC.optionalFieldOf("slots", (Object)EquipmentSlotGroup.ANY).forGetter(TriggerInstance::slots), (App)ItemPredicate.CODEC.optionalFieldOf("items", (Object)ItemPredicate.Builder.item().build()).forGetter(TriggerInstance::items)).apply((Applicative)inst, TriggerInstance::new));

        public static Criterion<TriggerInstance> hasItems(EquipmentSlotGroup slots, ItemPredicate.Builder items) {
            return TriggerInstance.hasItems(slots, items.build());
        }

        public static Criterion<TriggerInstance> hasItems(EquipmentSlotGroup slots, ItemPredicate items) {
            return Apoth.Triggers.EQUIPPED_ITEM.createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), slots, items));
        }

        public static Criterion<TriggerInstance> hasItems(EquipmentSlotGroup slots, ItemLike item) {
            ItemPredicate predicate = new ItemPredicate(Optional.of(HolderSet.direct((Holder[])new Holder[]{item.asItem().builtInRegistryHolder()})), MinMaxBounds.Ints.ANY, DataComponentPredicate.EMPTY, Map.of());
            return TriggerInstance.hasItems(slots, predicate);
        }

        public boolean matches(EquipmentSlot slot, ItemStack stack) {
            if (!this.slots.test(slot)) {
                return false;
            }
            return !stack.isEmpty() && this.items.test(stack);
        }
    }
}

