/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.universalgrid.common.wirelessuniversalgrid;

import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.energy.EnergyStorageImpl;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.energy.AbstractNetworkEnergyItem;
import com.refinedmods.refinedstorage.common.api.support.energy.EnergyItemHelper;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemContext;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemHelper;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.quartzarsenal.common.Items;
import com.ultramega.universalgrid.common.Platform;
import com.ultramega.universalgrid.common.gui.view.GridTypes;
import com.ultramega.universalgrid.common.packet.c2s.UseUniversalGridOnServerPacket;
import com.ultramega.universalgrid.common.packet.s2c.SetCursorPosWindowPacket;
import com.ultramega.universalgrid.common.packet.s2c.UseUniversalGridOnClientPacket;
import com.ultramega.universalgrid.common.registry.DataComponents;
import com.ultramega.universalgrid.common.wirelessuniversalgrid.WirelessUniversalGridState;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class WirelessUniversalGridItem
extends AbstractNetworkEnergyItem {
    private final boolean creative;

    public WirelessUniversalGridItem(boolean creative, EnergyItemHelper energyItemHelper, NetworkItemHelper networkItemHelper) {
        super(new Item.Properties().stacksTo(1), energyItemHelper, networkItemHelper);
        this.creative = creative;
    }

    public EnergyStorage createEnergyStorage(ItemStack stack) {
        EnergyStorageImpl energyStorage = new EnergyStorageImpl(Platform.getConfig().getWirelessUniversalGrid().getEnergyCapacity());
        return RefinedStorageApi.INSTANCE.asItemEnergyStorage((EnergyStorage)energyStorage, stack);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        SlotReference slotReference = RefinedStorageApi.INSTANCE.createInventorySlotReference(player, hand);
        this.useOnClient(level, stack, slotReference);
        return InteractionResultHolder.consume((Object)stack);
    }

    public void use(ServerPlayer player, ItemStack stack, SlotReference slotReference) {
        com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToClient(player, (CustomPacketPayload)new UseUniversalGridOnClientPacket(stack, slotReference));
    }

    protected void use(@Nullable Component name, ServerPlayer player, SlotReference slotReference, NetworkItemContext context) {
    }

    public void useOnClient(Level level, ItemStack stack, SlotReference slotReference) {
        if (level.isClientSide()) {
            GridTypes gridType = Platform.getConfig().getWirelessUniversalGrid().getGridType();
            com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new UseUniversalGridOnServerPacket(stack, slotReference, gridType));
        }
    }

    public void useGridCorrectly(ServerPlayer serverPlayer, Level level, SlotReference slotReference, GridTypes gridType) {
        if (level.getServer() != null) {
            slotReference.resolve((Player)serverPlayer).ifPresent(s -> this.openGridType(serverPlayer, (ItemStack)s, slotReference, gridType));
        }
    }

    private void openGridType(ServerPlayer serverPlayer, ItemStack stack, SlotReference slotReference, GridTypes gridType) {
        switch (gridType) {
            case WIRELESS_GRID: {
                com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getWirelessGrid().use(serverPlayer, stack, slotReference);
                break;
            }
            case WIRELESS_CRAFTING_GRID: {
                Items.INSTANCE.getWirelessCraftingGrid().use(serverPlayer, stack, slotReference);
                break;
            }
            case WIRELESS_AUTOCRAFTING_MONITOR: {
                com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getWirelessAutocraftingMonitor().use(serverPlayer, stack, slotReference);
            }
        }
        WirelessUniversalGridState state = (WirelessUniversalGridState)stack.get(DataComponents.INSTANCE.getWirelessUniversalGridState());
        if (state == null) {
            return;
        }
        if (!state.applyCursorPos()) {
            return;
        }
        com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToClient(serverPlayer, (CustomPacketPayload)new SetCursorPosWindowPacket(state.cursorX(), state.cursorY()));
        Platform.setWirelessUniversalGridState(stack, state.cursorX(), state.cursorY(), false);
    }
}

