/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.gate.endless;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.gateways.Gateways;
import dev.shadowsoffire.placebo.codec.CodecMap;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public interface ApplicationMode
extends CodecProvider<ApplicationMode> {
    public static final CodecMap<ApplicationMode> CODEC = new CodecMap("Gateways Endless Application Mode");

    public int getApplicationCount(int var1);

    public MutableComponent getDescription();

    public static void initCodecs() {
        ApplicationMode.register("after_wave", AfterWave.CODEC);
        ApplicationMode.register("after_every_n_waves", AfterEveryNWaves.CODEC);
        ApplicationMode.register("only_on_wave", OnlyOnWave.CODEC);
        ApplicationMode.register("only_on_every_n_waves", OnlyOnEveryNWaves.CODEC);
    }

    private static void register(String id, Codec<? extends ApplicationMode> codec) {
        CODEC.register(Gateways.loc(id), codec);
    }

    public record AfterWave(int wave) implements ApplicationMode
    {
        public static Codec<AfterWave> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)1, (int)1024).fieldOf("wave").forGetter(AfterWave::wave)).apply((Applicative)inst, AfterWave::new));

        @Override
        public int getApplicationCount(int wave) {
            return wave >= this.wave ? 1 : 0;
        }

        @Override
        public MutableComponent getDescription() {
            return Component.translatable((String)"appmode.gateways.after_wave", (Object[])new Object[]{this.wave});
        }

        public Codec<? extends ApplicationMode> getCodec() {
            return CODEC;
        }
    }

    public record AfterEveryNWaves(int waves, int max) implements ApplicationMode
    {
        public static Codec<AfterEveryNWaves> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)1, (int)1024).fieldOf("waves").forGetter(AfterEveryNWaves::waves), (App)Codec.intRange((int)1, (int)1024).fieldOf("max").forGetter(AfterEveryNWaves::max)).apply((Applicative)inst, AfterEveryNWaves::new));

        @Override
        public int getApplicationCount(int wave) {
            return Math.min(wave / this.waves, this.max);
        }

        @Override
        public MutableComponent getDescription() {
            return Component.translatable((String)"appmode.gateways.after_every_n_waves", (Object[])new Object[]{this.waves, this.max});
        }

        public Codec<? extends ApplicationMode> getCodec() {
            return CODEC;
        }
    }

    public record OnlyOnWave(int wave) implements ApplicationMode
    {
        public static Codec<OnlyOnWave> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)1, (int)1024).fieldOf("wave").forGetter(OnlyOnWave::wave)).apply((Applicative)inst, OnlyOnWave::new));

        @Override
        public int getApplicationCount(int wave) {
            return wave == this.wave ? 1 : 0;
        }

        @Override
        public MutableComponent getDescription() {
            return Component.translatable((String)"appmode.gateways.only_on_wave", (Object[])new Object[]{this.wave});
        }

        public Codec<? extends ApplicationMode> getCodec() {
            return CODEC;
        }
    }

    public record OnlyOnEveryNWaves(int waves) implements ApplicationMode
    {
        public static Codec<OnlyOnEveryNWaves> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)1, (int)1024).fieldOf("waves").forGetter(OnlyOnEveryNWaves::waves)).apply((Applicative)inst, OnlyOnEveryNWaves::new));

        @Override
        public int getApplicationCount(int wave) {
            return wave % this.waves == 0 ? 1 : 0;
        }

        @Override
        public MutableComponent getDescription() {
            return Component.translatable((String)"appmode.gateways.only_on_every_n_waves", (Object[])new Object[]{this.waves});
        }

        public Codec<? extends ApplicationMode> getCodec() {
            return CODEC;
        }
    }
}

