/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.gate;

import com.mojang.serialization.Codec;
import dev.shadowsoffire.gateways.GatewayObjects;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.BossEventSettings;
import dev.shadowsoffire.gateways.gate.Failure;
import dev.shadowsoffire.gateways.gate.GateRules;
import dev.shadowsoffire.gateways.gate.SpawnAlgorithms;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface Gateway
extends CodecProvider<Gateway> {
    public Size size();

    public TextColor color();

    public List<Failure> failures();

    public SpawnAlgorithms.SpawnAlgorithm spawnAlgo();

    public GateRules rules();

    public BossEventSettings bossSettings();

    public GatewayEntity createEntity(Level var1, Player var2);

    public void appendPearlTooltip(Item.TooltipContext var1, List<Component> var2, TooltipFlag var3);

    public void renderBossBar(GatewayEntity var1, Object var2, int var3, int var4, boolean var5);

    default public double getLeashRangeSq() {
        double leashRange = this.rules().leashRange();
        return leashRange * leashRange;
    }

    default public Holder<SoundEvent> soundtrack() {
        return GatewayObjects.GATE_AMBIENT;
    }

    @Nullable
    default public Component canOpen(Player player) {
        return null;
    }

    public static enum Size {
        SMALL(1.0f, EntityDimensions.fixed((float)2.0f, (float)2.0f)),
        MEDIUM(2.0f, EntityDimensions.fixed((float)4.0f, (float)4.0f)),
        LARGE(2.5f, EntityDimensions.fixed((float)5.5f, (float)5.5f));

        public static final Codec<Size> CODEC;
        private final float scale;
        private final EntityDimensions dims;

        private Size(float scale, EntityDimensions dims) {
            this.scale = scale;
            this.dims = dims;
        }

        public float getScale() {
            return this.scale;
        }

        public EntityDimensions getDims() {
            return this.dims;
        }

        static {
            CODEC = PlaceboCodecs.enumCodec(Size.class);
        }
    }
}

