/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.client;

import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.craftingtweaks.api.ButtonProperties;
import net.blay09.mods.craftingtweaks.api.ButtonStyle;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.TweakType;
import net.blay09.mods.craftingtweaks.client.GuiImageButton;
import net.blay09.mods.craftingtweaks.client.ITooltipProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public abstract class GuiTweakButton
extends GuiImageButton
implements ITooltipProvider {
    private final AbstractContainerScreen<?> screen;
    private final CraftingGrid grid;
    private final TweakType tweak;
    private final TweakType altTweak;
    private final Tooltip normalTooltip;
    private final Tooltip altTooltip;
    private final ButtonProperties normalProperties;
    private final ButtonProperties altProperties;
    private int lastGuiLeft;
    private int lastGuiTop;

    public GuiTweakButton(@Nullable AbstractContainerScreen<?> screen, int x, int y, ButtonStyle style, CraftingGrid grid, TweakType tweak, TweakType altTweak) {
        super(x, y, style.getTweak(tweak));
        this.screen = screen;
        if (screen != null) {
            this.lastGuiLeft = ((AbstractContainerScreenAccessor)screen).getLeftPos();
            this.lastGuiTop = ((AbstractContainerScreenAccessor)screen).getTopPos();
        }
        this.grid = grid;
        this.tweak = tweak;
        this.altTweak = altTweak;
        this.normalTooltip = this.createTooltip(tweak);
        this.altTooltip = this.createTooltip(altTweak);
        this.normalProperties = this.properties;
        this.altProperties = style.getTweak(altTweak);
    }

    public void onClick(double mouseX, double mouseY) {
        this.playDownSound(Minecraft.getInstance().getSoundManager());
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            this.onTweakButtonClicked((Player)player, this.screen != null ? this.screen.getMenu() : player.containerMenu, this.grid, Screen.hasShiftDown() ? this.altTweak : this.tweak);
        }
    }

    protected abstract void onTweakButtonClicked(Player var1, AbstractContainerMenu var2, CraftingGrid var3, TweakType var4);

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.setTooltip(Screen.hasShiftDown() ? this.altTooltip : this.normalTooltip);
        if (this.screen != null) {
            int guiLeft = ((AbstractContainerScreenAccessor)this.screen).getLeftPos();
            int guiTop = ((AbstractContainerScreenAccessor)this.screen).getTopPos();
            if (guiLeft != this.lastGuiLeft || guiTop != this.lastGuiTop) {
                this.setX(this.getX() + guiLeft - this.lastGuiLeft);
                this.setY(this.getY() + guiTop - this.lastGuiTop);
            }
            this.lastGuiLeft = guiLeft;
            this.lastGuiTop = guiTop;
        }
        this.properties = Screen.hasShiftDown() ? this.altProperties : this.normalProperties;
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private Tooltip createTooltip(TweakType tweak) {
        return switch (tweak) {
            default -> throw new MatchException(null, null);
            case TweakType.Rotate, TweakType.RotateCounterClockwise -> Tooltip.create((Component)Component.translatable((String)"tooltip.craftingtweaks.rotate"));
            case TweakType.Clear -> Tooltip.create((Component)Component.translatable((String)"tooltip.craftingtweaks.clear"));
            case TweakType.Balance -> Tooltip.create((Component)Component.translatable((String)"tooltip.craftingtweaks.balance"));
            case TweakType.ForceClear -> Tooltip.create((Component)Component.translatable((String)"tooltip.craftingtweaks.forceClear").append((Component)Component.literal((String)"\n")).append((Component)Component.translatable((String)"tooltip.craftingtweaks.forceClearInfo").withStyle(ChatFormatting.GRAY)));
            case TweakType.Spread -> Tooltip.create((Component)Component.translatable((String)"tooltip.craftingtweaks.spread"));
        };
    }

    @Override
    public List<Component> getTooltipComponents() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        switch (this.tweak) {
            case Rotate: 
            case RotateCounterClockwise: {
                tooltip.add((Component)Component.translatable((String)"tooltip.craftingtweaks.rotate"));
                break;
            }
            case Clear: {
                tooltip.add((Component)Component.translatable((String)"tooltip.craftingtweaks.clear"));
                break;
            }
            case ForceClear: {
                tooltip.add((Component)Component.translatable((String)"tooltip.craftingtweaks.forceClear"));
                MutableComponent forceClearInfoText = Component.translatable((String)"tooltip.craftingtweaks.forceClearInfo");
                forceClearInfoText.withStyle(ChatFormatting.GRAY);
                tooltip.add((Component)forceClearInfoText);
                break;
            }
            case Balance: {
                tooltip.add((Component)Component.translatable((String)"tooltip.craftingtweaks.balance"));
                break;
            }
            case Spread: {
                tooltip.add((Component)Component.translatable((String)"tooltip.craftingtweaks.spread"));
            }
        }
        return tooltip;
    }
}

