/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queryparser.ext;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.queryparser.classic.ParseException;
import guideme.internal.shaded.lucene.queryparser.classic.QueryParser;
import guideme.internal.shaded.lucene.queryparser.ext.ExtensionQuery;
import guideme.internal.shaded.lucene.queryparser.ext.Extensions;
import guideme.internal.shaded.lucene.queryparser.ext.ParserExtension;
import guideme.internal.shaded.lucene.search.Query;

public class ExtendableQueryParser
extends QueryParser {
    private final String defaultField;
    private final Extensions extensions;
    private static final Extensions DEFAULT_EXTENSION = new Extensions();

    public ExtendableQueryParser(String f, Analyzer a) {
        this(f, a, DEFAULT_EXTENSION);
    }

    public ExtendableQueryParser(String f, Analyzer a, Extensions ext) {
        super(f, a);
        this.defaultField = f;
        this.extensions = ext;
    }

    public char getExtensionFieldDelimiter() {
        return this.extensions.getExtensionFieldDelimiter();
    }

    @Override
    protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        Extensions.Pair<String, String> splitExtensionField = this.extensions.splitExtensionField(this.defaultField, field);
        ParserExtension extension = this.extensions.getExtension(splitExtensionField.cud());
        if (extension != null) {
            return extension.parse(new ExtensionQuery(this, splitExtensionField.cur(), queryText));
        }
        return super.getFieldQuery(field, queryText, quoted);
    }
}

