/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.miscellaneous;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.analysis.DelegatingAnalyzerWrapper;
import java.util.Collections;
import java.util.Map;

public final class PerFieldAnalyzerWrapper
extends DelegatingAnalyzerWrapper {
    private final Analyzer defaultAnalyzer;
    private final Map<String, Analyzer> fieldAnalyzers;

    public PerFieldAnalyzerWrapper(Analyzer defaultAnalyzer) {
        this(defaultAnalyzer, null);
    }

    public PerFieldAnalyzerWrapper(Analyzer defaultAnalyzer, Map<String, Analyzer> fieldAnalyzers) {
        super(PER_FIELD_REUSE_STRATEGY);
        this.defaultAnalyzer = defaultAnalyzer;
        this.fieldAnalyzers = fieldAnalyzers != null ? fieldAnalyzers : Collections.emptyMap();
    }

    @Override
    protected Analyzer getWrappedAnalyzer(String fieldName) {
        Analyzer analyzer = this.fieldAnalyzers.get(fieldName);
        return analyzer != null ? analyzer : this.defaultAnalyzer;
    }

    public String toString() {
        return "PerFieldAnalyzerWrapper(" + String.valueOf(this.fieldAnalyzers) + ", default=" + String.valueOf(this.defaultAnalyzer) + ")";
    }
}

