/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.storage.rendering.types;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.client.RenderingCacheKey;
import com.ldtteam.structurize.config.ClientConfiguration;
import com.ldtteam.structurize.network.messages.SyncPreviewCacheToServer;
import com.ldtteam.structurize.storage.StructurePacks;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class BlueprintPreviewData {
    private RotationMirror rotationMirror = RotationMirror.NONE;
    @Nullable
    private BlockPos pos;
    private int groundOffset = 0;
    @Nullable
    private Future<Blueprint> blueprintFuture;
    @Nullable
    private Blueprint blueprint;
    private String blueprintPath = "";
    private String packName = "";
    private RenderingCacheKey renderKey;
    private final boolean serverSyncEnabled;
    private float overridePreviewTransparency = -1.0f;
    private BlockState solidSubstitutionOverride = null;
    private boolean renderBlocksNice;

    public BlueprintPreviewData() {
        this(true);
    }

    public BlueprintPreviewData(boolean serverSyncEnabled) {
        this.renderBlocksNice = Structurize.getConfig().getClient() != null && (Boolean)((ClientConfiguration)Structurize.getConfig().getClient()).renderPlaceholdersNice.get() != false;
        this.serverSyncEnabled = serverSyncEnabled;
    }

    public BlueprintPreviewData(RegistryFriendlyByteBuf byteBuf) {
        this(byteBuf, true);
    }

    public BlueprintPreviewData(RegistryFriendlyByteBuf byteBuf, boolean serverSyncEnabled) {
        this.renderBlocksNice = Structurize.getConfig().getClient() != null && (Boolean)((ClientConfiguration)Structurize.getConfig().getClient()).renderPlaceholdersNice.get() != false;
        this.serverSyncEnabled = serverSyncEnabled;
        this.pos = byteBuf.readBlockPos();
        this.packName = byteBuf.readUtf(Short.MAX_VALUE);
        this.blueprintPath = byteBuf.readUtf(Short.MAX_VALUE);
        this.blueprintFuture = StructurePacks.hasPack(this.packName) ? StructurePacks.getBlueprintFuture(this.packName, this.blueprintPath, (HolderLookup.Provider)byteBuf.registryAccess()) : null;
        this.rotationMirror = RotationMirror.values()[byteBuf.readByte()];
    }

    public void writeToBuf(FriendlyByteBuf byteBuf) {
        byteBuf.writeBlockPos(this.pos == null ? BlockPos.ZERO : this.pos);
        if (this.blueprint == null) {
            byteBuf.writeUtf(this.packName);
            byteBuf.writeUtf(this.blueprintPath);
        } else {
            byteBuf.writeUtf(StructurePacks.getSelectedPack().getName());
            byteBuf.writeUtf(StructurePacks.getSelectedPack().getSubPath(this.blueprint.getFilePath().resolve(this.blueprint.getFileName() + ".blueprint")));
        }
        byteBuf.writeByte(this.rotationMirror.ordinal());
    }

    public void setBlueprintFuture(Future<Blueprint> blueprintFuture) {
        this.blueprintFuture = blueprintFuture;
    }

    public void setGroundOffset(int offset) {
        this.pos = this.pos.below(this.groundOffset);
        this.groundOffset = offset;
        this.pos = this.pos.above(this.groundOffset);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Blueprint getBlueprint() {
        if (this.pos == null) {
            return null;
        }
        if (this.blueprintFuture != null && this.blueprintFuture.isDone()) {
            try {
                if (this.blueprintFuture.get() != null) {
                    this.setBlueprint(this.blueprintFuture.get());
                    this.blueprintFuture = null;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        return this.blueprint;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setBlueprint(Blueprint blueprint) {
        this.blueprintFuture = null;
        if (blueprint == null) {
            this.blueprint = null;
        } else if (!blueprint.equals(this.blueprint)) {
            this.blueprint = blueprint;
            this.applyRotationMirrorAndSync();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void mirror() {
        this.rotationMirror = this.rotationMirror.mirrorate();
        this.applyRotationMirrorAndSync();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void rotate(Rotation rotation) {
        this.rotationMirror = this.rotationMirror.rotate(rotation);
        this.applyRotationMirrorAndSync();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setRotationMirror(RotationMirror rotationMirror) {
        this.rotationMirror = rotationMirror;
        this.applyRotationMirrorAndSync();
    }

    public void syncChangesToServer() {
        if (this.serverSyncEnabled && ((Boolean)((ClientConfiguration)Structurize.getConfig().getClient()).sharePreviews.get()).booleanValue() && (this.blueprint == null || this.blueprint.getName() != null)) {
            new SyncPreviewCacheToServer(this).sendToServer();
        }
    }

    public void move(BlockPos offset) {
        if (this.pos != null) {
            this.setPos(this.pos.offset((Vec3i)offset));
        }
    }

    public boolean isEmpty() {
        return this.blueprintFuture == null && this.blueprint == null;
    }

    public RotationMirror getRotationMirror() {
        return this.rotationMirror;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
        if (pos != null) {
            this.syncChangesToServer();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void applyRotationMirrorAndSync() {
        if (this.blueprint == null) {
            return;
        }
        this.blueprint.setRotationMirror(this.rotationMirror, (Level)Minecraft.getInstance().level);
        this.renderKey = new RenderingCacheKey(this.rotationMirror, this.blueprint);
        this.syncChangesToServer();
    }

    public RenderingCacheKey getRenderKey() {
        if (this.blueprintFuture != null) {
            this.getBlueprint();
        }
        return this.renderKey;
    }

    public boolean isServerSyncEnabled() {
        return this.serverSyncEnabled;
    }

    public void setRenderBlocksNice(boolean renderNice) {
        this.renderBlocksNice = renderNice;
    }

    public boolean getRenderBlocksNice() {
        return this.renderBlocksNice;
    }

    public void setOverridePreviewTransparency(float overridePreviewTransparency) {
        this.overridePreviewTransparency = Mth.clamp((float)overridePreviewTransparency, (float)-1.0f, (float)1.0f);
    }

    public float getOverridePreviewTransparency() {
        return this.overridePreviewTransparency;
    }

    public BlockState getSolidSubstitutionOverride() {
        return this.solidSubstitutionOverride;
    }

    public void setSolidSubstitutionOverride(BlockState solidSubstitutionOverride) {
        this.solidSubstitutionOverride = solidSubstitutionOverride;
    }
}

