/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.config.ServerConfiguration;
import com.ldtteam.structurize.network.messages.BuildToolPlacementMessage;
import com.ldtteam.structurize.network.messages.ClientBlueprintRequestMessage;
import com.ldtteam.structurize.storage.BlueprintPlacementHandling;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.commons.io.FilenameUtils;

public class BlueprintSyncMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"structurize", (String)"blueprint_sync", BlueprintSyncMessage::new);
    public final BuildToolPlacementMessage.HandlerType type;
    public final String handlerId;
    public String structurePackId;
    public final String blueprintPath;
    public final BlockPos pos;
    public final RotationMirror rotationMirror;
    public final byte[] blueprintData;

    protected BlueprintSyncMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.type = BuildToolPlacementMessage.HandlerType.values()[buf.readInt()];
        this.handlerId = buf.readUtf(Short.MAX_VALUE);
        this.structurePackId = buf.readUtf(Short.MAX_VALUE);
        this.blueprintPath = FilenameUtils.normalize((String)buf.readUtf(Short.MAX_VALUE));
        this.pos = buf.readBlockPos();
        this.rotationMirror = RotationMirror.values()[buf.readInt()];
        this.blueprintData = buf.readByteArray();
    }

    public BlueprintSyncMessage(ClientBlueprintRequestMessage msg, byte[] blueprintData) {
        super(TYPE);
        this.type = msg.type;
        this.handlerId = msg.handlerId;
        this.structurePackId = msg.structurePackId;
        this.blueprintPath = msg.blueprintPath;
        this.pos = msg.pos;
        this.rotationMirror = msg.rotationMirror;
        this.blueprintData = blueprintData;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeUtf(this.handlerId);
        buf.writeUtf(this.structurePackId);
        buf.writeUtf(this.blueprintPath);
        buf.writeBlockPos(this.pos);
        buf.writeInt(this.rotationMirror.ordinal());
        buf.writeByteArray(this.blueprintData);
    }

    protected void onExecute(IPayloadContext context, ServerPlayer player) {
        if (((Boolean)((ServerConfiguration)Structurize.getConfig().getServer()).allowPlayerSchematics.get()).booleanValue()) {
            BlueprintPlacementHandling.handlePlacement(this, player);
        }
    }
}

