/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.api.Log;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class AddRemoveTagMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"structurize", (String)"add_remove_tag", AddRemoveTagMessage::new);
    private final boolean add;
    private final String tag;
    private final BlockPos anchorPos;
    private final BlockPos tagPos;

    protected AddRemoveTagMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.add = buf.readBoolean();
        this.tag = buf.readUtf(Short.MAX_VALUE);
        this.anchorPos = buf.readBlockPos();
        this.tagPos = buf.readBlockPos();
    }

    public AddRemoveTagMessage(boolean add, String tag, BlockPos tagPos, BlockPos anchorPos) {
        super(TYPE);
        this.anchorPos = anchorPos;
        this.tagPos = tagPos;
        this.add = add;
        this.tag = tag;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.add);
        buf.writeUtf(this.tag);
        buf.writeBlockPos(this.anchorPos);
        buf.writeBlockPos(this.tagPos);
    }

    protected void onExecute(IPayloadContext context, ServerPlayer player) {
        BlockEntity te = player.level().getBlockEntity(this.anchorPos);
        if (te instanceof IBlueprintDataProviderBE) {
            IBlueprintDataProviderBE dataTE = (IBlueprintDataProviderBE)te;
            if (this.add) {
                dataTE.addTag(this.tagPos, this.tag);
            } else {
                dataTE.removeTag(this.tagPos, this.tag);
            }
        } else {
            Log.getLogger().info("Tried to add data tag to invalid tileentity:" + String.valueOf(te));
        }
    }
}

