/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.upgrade.example;

import com.mojang.serialization.MapCodec;
import dev.compactmods.machines.api.room.RoomInstance;
import dev.compactmods.machines.api.room.upgrade.RoomUpgradeComponent;
import dev.compactmods.machines.api.room.upgrade.RoomUpgradeComponentType;
import dev.compactmods.machines.api.room.upgrade.RoomUpgradeInstance;
import dev.compactmods.machines.api.room.upgrade.event.NeoForgeEventHandler;
import dev.compactmods.machines.api.room.upgrade.event.NeoForgeEventListener;
import dev.compactmods.machines.api.room.upgrade.event.RoomUpgradeComponentEvent;
import dev.compactmods.machines.api.room.upgrade.event.lifecycle.UpgradeAppliedEventListener;
import dev.compactmods.machines.api.room.upgrade.event.lifecycle.UpgradeRemovedEventListener;
import dev.compactmods.machines.room.upgrade.RoomUpgrades;
import dev.compactmods.machines.server.CompactMachinesServer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkLoaderUpgradeComponent
implements RoomUpgradeComponent,
NeoForgeEventListener {
    public static final MapCodec<ChunkLoaderUpgradeComponent> CODEC = MapCodec.unit(ChunkLoaderUpgradeComponent::new);
    private final AppliedHandler appliedHandler = new AppliedHandler();
    private final RemovedHandler removedHandler = new RemovedHandler(this);
    private final NeoForgeEventHandler<ServerStartedEvent> neoServerStartedHandler = new NeoForgeEventHandler<ServerStartedEvent>(){

        public Class<ServerStartedEvent> eventType() {
            return ServerStartedEvent.class;
        }

        public void handle(RoomUpgradeInstance instance, ServerStartedEvent event) {
            LOGGER.info("Received server started");
            ChunkLoaderUpgradeComponent.this.appliedHandler.handle(instance);
        }
    };
    private static final Logger LOGGER = LogManager.getLogger();

    public RoomUpgradeComponentType<?> getType() {
        return (RoomUpgradeComponentType)RoomUpgrades.CHUNK_LOADER.get();
    }

    public Stream<RoomUpgradeComponentEvent> gatherEvents() {
        return Stream.of(this.appliedHandler, this.removedHandler);
    }

    public Stream<NeoForgeEventHandler<? extends Event>> gatherNeoEvents() {
        return Stream.of(this.neoServerStartedHandler);
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        tooltipAdder.accept((Component)Component.literal((String)"Chunk Loader").withColor(-6250336));
    }

    public static class AppliedHandler
    implements UpgradeAppliedEventListener {
        public void handle(RoomUpgradeInstance instance) {
            RoomInstance roomInstance = instance.roomInstance();
            roomInstance.boundaries().innerChunkPositions().forEach(chunkPos -> CompactMachinesServer.CHUNK_TICKET_CONTROLLER.forceChunk(instance.roomInstance().level(), instance.upgradeID(), chunkPos.x, chunkPos.z, true, true));
        }
    }

    public class RemovedHandler
    implements UpgradeRemovedEventListener {
        public RemovedHandler(ChunkLoaderUpgradeComponent this$0) {
        }

        public void handle(RoomUpgradeInstance instance) {
            RoomInstance roomInstance = instance.roomInstance();
            roomInstance.boundaries().innerChunkPositions().forEach(chunkPos -> CompactMachinesServer.CHUNK_TICKET_CONTROLLER.forceChunk(instance.roomInstance().level(), instance.upgradeID(), chunkPos.x, chunkPos.z, false, true));
        }
    }
}

