/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.upgrade.event;

import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.room.RoomInstance;
import dev.compactmods.machines.api.room.capability.RoomCapabilities;
import dev.compactmods.machines.api.room.upgrade.IRoomUpgradeAccessor;
import dev.compactmods.machines.api.room.upgrade.RoomUpgradeComponent;
import dev.compactmods.machines.api.room.upgrade.RoomUpgradeInstance;
import dev.compactmods.machines.api.room.upgrade.event.NeoForgeEventListener;
import java.util.Set;
import java.util.stream.Collectors;
import net.neoforged.bus.api.Event;

public class NeoForgeEventProcessor<TEvt extends Event> {
    private final Class<TEvt> eventClass;

    public NeoForgeEventProcessor(Class<TEvt> eClass) {
        this.eventClass = eClass;
    }

    public void process(TEvt event) {
        Set allRoomInstances = CompactMachines.roomRegistrar().allRooms().collect(Collectors.toSet());
        for (RoomInstance instance : allRoomInstances) {
            IRoomUpgradeAccessor accessor = (IRoomUpgradeAccessor)instance.getCapability(RoomCapabilities.UPGRADES);
            accessor.all().forEach(inst -> this.processSingleUpgradeInstance((RoomUpgradeInstance)inst, event));
        }
    }

    private void processSingleUpgradeInstance(RoomUpgradeInstance roomUpgradeInstance, TEvt evt) {
        for (RoomUpgradeComponent component : roomUpgradeInstance.upgradeComponents()) {
            if (!(component instanceof NeoForgeEventListener)) continue;
            NeoForgeEventListener eventListener = (NeoForgeEventListener)component;
            eventListener.gatherNeoEvents().filter(eh -> eh.eventType().equals(this.eventClass)).map(eh -> eh).forEach(eh -> eh.handle(roomUpgradeInstance, evt));
        }
    }

    public Class<TEvt> type() {
        return this.eventClass;
    }
}

