/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets.gui;

import com.supermartijn642.core.gui.ItemBaseContainer;
import com.supermartijn642.simplemagnets.AdvancedMagnet;
import com.supermartijn642.simplemagnets.MagnetItem;
import com.supermartijn642.simplemagnets.SimpleMagnets;
import com.supermartijn642.simplemagnets.gui.DummySlot;
import java.util.function.Function;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class MagnetContainer
extends ItemBaseContainer {
    public final int slot;
    private final Function<Integer, ItemStack> itemHandler = slot -> {
        AdvancedMagnet.Settings settings = (AdvancedMagnet.Settings)((ItemStack)this.object).get(AdvancedMagnet.SETTINGS);
        return settings != null && settings.itemFilter().get((int)slot) != null ? settings.itemFilter().get((int)slot) : ItemStack.EMPTY;
    };

    public MagnetContainer(Player player, int slot2) {
        super(SimpleMagnets.magnet_container, player, slot2, stack -> stack.getItem() instanceof MagnetItem);
        this.slot = slot2;
        this.addSlots();
    }

    protected void addSlots(Player player, ItemStack stack) {
        int column;
        Inventory inventory = player.getInventory();
        for (column = 0; column < 9; ++column) {
            this.addSlot(new DummySlot(column, 8 + column * 18, 80){

                @Override
                public ItemStack getItem() {
                    return MagnetContainer.this.itemHandler.apply(this.index);
                }

                public boolean mayPickup(Player player) {
                    return false;
                }
            });
        }
        for (int row = 0; row < 3; ++row) {
            for (int column2 = 0; column2 < 9; ++column2) {
                this.addSlot(new Slot((Container)inventory, row * 9 + column2 + 9, 32 + 18 * column2, 114 + 18 * row));
            }
        }
        for (column = 0; column < 9; ++column) {
            int index = column;
            this.addSlot(new Slot((Container)inventory, index, 32 + 18 * column, 172){

                public boolean mayPickup(Player player) {
                    return this.index != MagnetContainer.this.slot;
                }
            });
        }
    }

    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        if (!this.validateObjectOrClose()) {
            return;
        }
        if (clickType == ClickType.SWAP && dragType == this.slot) {
            return;
        }
        if (slotId < 9 && slotId >= 0) {
            AdvancedMagnet.Settings settings = (AdvancedMagnet.Settings)((ItemStack)this.object).get(AdvancedMagnet.SETTINGS);
            if (this.getCarried().isEmpty()) {
                if (settings != null) {
                    ((ItemStack)this.object).set(AdvancedMagnet.SETTINGS, (Object)settings.itemFilter(slotId, null));
                }
            } else {
                ItemStack stack = this.getCarried().copy();
                stack.setCount(1);
                if (settings == null) {
                    settings = AdvancedMagnet.Settings.defaultSettings();
                }
                ((ItemStack)this.object).set(AdvancedMagnet.SETTINGS, (Object)settings.itemFilter(slotId, stack));
            }
            return;
        }
        super.clicked(slotId, dragType, clickType, player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        if (!this.validateObjectOrClose()) {
            return ItemStack.EMPTY;
        }
        if (index < 9) {
            AdvancedMagnet.Settings settings = (AdvancedMagnet.Settings)((ItemStack)this.object).get(AdvancedMagnet.SETTINGS);
            if (this.getCarried().isEmpty()) {
                if (settings != null) {
                    ((ItemStack)this.object).set(AdvancedMagnet.SETTINGS, (Object)settings.itemFilter(index, null));
                }
            } else {
                ItemStack stack = this.getCarried().copy();
                stack.setCount(1);
                if (settings == null) {
                    settings = AdvancedMagnet.Settings.defaultSettings();
                }
                ((ItemStack)this.object).set(AdvancedMagnet.SETTINGS, (Object)settings.itemFilter(index, stack));
            }
        } else if (!this.getSlot(index).getItem().isEmpty()) {
            boolean contains = false;
            int firstEmpty = -1;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.itemHandler.apply(i);
                if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.getSlot(index).getItem())) {
                    contains = true;
                    break;
                }
                if (!stack.isEmpty() || firstEmpty != -1) continue;
                firstEmpty = i;
            }
            if (!contains && firstEmpty != -1) {
                ItemStack stack = this.getSlot(index).getItem().copy();
                stack.setCount(1);
                AdvancedMagnet.Settings settings = (AdvancedMagnet.Settings)((ItemStack)this.object).get(AdvancedMagnet.SETTINGS);
                if (settings == null) {
                    settings = AdvancedMagnet.Settings.defaultSettings();
                }
                ((ItemStack)this.object).set(AdvancedMagnet.SETTINGS, (Object)settings.itemFilter(firstEmpty, stack));
            }
        }
        return ItemStack.EMPTY;
    }

    public ItemStack getObject(ItemStack oldObject) {
        return super.getObject(oldObject);
    }

    public boolean validateObject(ItemStack object) {
        return super.validateObject(object);
    }
}

