/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.utilityvest.common.menu;

import dev.satherov.utilityvest.common.capabilities.UVVestCapability;
import dev.satherov.utilityvest.common.menu.UVVestMenu;
import dev.satherov.utilityvest.core.UVRegistry;
import dev.satherov.utilityvest.core.annotations.NothingNull;
import dev.satherov.utilityvest.core.lang.UVLanguage;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

@NothingNull
public class UVFilterMenu
extends UVVestMenu {
    public UVFilterMenu(int containerId, Inventory inventory, int rows) {
        super(UVFilterMenu.getMenuProvider(rows), containerId, inventory, rows);
    }

    private static MenuType<?> getMenuProvider(int rows) {
        return switch (rows) {
            case 1 -> (MenuType)UVRegistry.FILTER_MENU_ONE.get();
            case 2 -> (MenuType)UVRegistry.FILTER_MENU_TWO.get();
            case 3 -> (MenuType)UVRegistry.FILTER_MENU_THREE.get();
            case 4 -> (MenuType)UVRegistry.FILTER_MENU_FOUR.get();
            case 5 -> (MenuType)UVRegistry.FILTER_MENU_FIVE.get();
            default -> throw new IllegalArgumentException("Invalid row count: " + rows);
        };
    }

    @Override
    protected void addVestSlots(Inventory inventory, UVVestCapability handler, int yOffset) {
        for (int j = 0; j < this.rows; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)handler.filters, k + j * 9, 8 + k * 18, 18 + j * 18){

                    public int getMaxStackSize() {
                        return 1;
                    }

                    public void onTake(Player player, ItemStack stack) {
                    }

                    public ItemStack remove(int amount) {
                        return ItemStack.EMPTY;
                    }

                    public boolean mayPlace(ItemStack stack) {
                        return false;
                    }

                    public boolean mayPickup(Player player) {
                        return false;
                    }
                });
            }
        }
        super.addVestSlots(inventory, handler, yOffset);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        if (slotId >= 0 && slotId < this.rows * 9) {
            Slot slot = (Slot)this.slots.get(slotId);
            if (clickType == ClickType.PICKUP || clickType == ClickType.PICKUP_ALL || clickType == ClickType.SWAP) {
                ItemStack stack = this.getCarried();
                if (stack.isStackable() && stack.getCount() > 0) {
                    slot.set(stack.copy());
                } else if (!stack.isStackable() && stack.getCount() > 0) {
                    try {
                        slot.set(stack.copy());
                    }
                    catch (Exception e) {
                        slot.set(ItemStack.EMPTY);
                        player.closeContainer();
                        player.displayClientMessage((Component)UVLanguage.ERROR_REJECTED.translate().withStyle(ChatFormatting.RED), true);
                        return;
                    }
                } else if (slot.getItem().getCount() > 0) {
                    slot.set(ItemStack.EMPTY);
                }
                return;
            }
            if (clickType == ClickType.QUICK_MOVE) {
                slot.set(ItemStack.EMPTY);
                return;
            }
        }
        super.clicked(slotId, button, clickType, player);
    }
}

