/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.util;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.regions_unexplored.Constants;
import net.regions_unexplored.RegionsUnexplored;
import net.regions_unexplored.mixin.access.BiomeSourceAccess;
import net.regions_unexplored.mixin.access.NoiseBasedChunkGeneratorAccess;
import net.regions_unexplored.mixin.access.NoiseGeneratorSettingsAccess;

public class AddSurfaceRuleUtil {
    public static void appendSurfaceRule(RegistryAccess registryAccess, ResourceKey<LevelStem> levelStemKey, SurfaceRules.RuleSource ruleSource) {
        LevelStem levelStem = (LevelStem)registryAccess.registryOrThrow(Registries.LEVEL_STEM).get(levelStemKey);
        if (levelStem == null) {
            Constants.LOG.info("Error, LevelStem is somehow empty. Fix this!! >:(");
            return;
        }
        ChunkGenerator chunkGenerator = levelStem.generator();
        boolean hasRegionsUnexploredBiome = chunkGenerator.getBiomeSource().possibleBiomes().stream().anyMatch(biomeHolder -> ((ResourceKey)biomeHolder.unwrapKey().orElseThrow()).location().getNamespace().equals("regions_unexplored"));
        if (hasRegionsUnexploredBiome) {
            if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
                NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)((NoiseBasedChunkGeneratorAccess)chunkGenerator).regions_unexplored$getNoiseGeneratorSettings().value();
                if (levelStemKey == LevelStem.NETHER) {
                    ((NoiseGeneratorSettingsAccess)noiseGeneratorSettings).regions_unexplored$setSurfaceRule(SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{ruleSource, RegionsUnexplored.getSurfaceRules(noiseGeneratorSettings.surfaceRule())}));
                } else {
                    ((NoiseGeneratorSettingsAccess)noiseGeneratorSettings).regions_unexplored$setSurfaceRule(SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{ruleSource, noiseGeneratorSettings.surfaceRule()}));
                }
            } else {
                Constants.LOG.info(String.format("Ignoring Region Unexplored appended surface rule in dimension: \"%s\" because the chunk generator was not an instance of \"NoiseBasedChunkGenerator\".\nThe chunk generator was an instanceof \"%s\".", levelStemKey.location(), chunkGenerator.getClass().getName()));
            }
        }
        MapCodec<? extends BiomeSource> biomeSourceCodec = ((BiomeSourceAccess)chunkGenerator.getBiomeSource()).regions_unexplored$invokeCodec();
        Constants.LOG.info(String.format("Loading dimension \"%s\" with biome source: \"%s\".", levelStemKey.location(), BuiltInRegistries.BIOME_SOURCE.getKey(biomeSourceCodec).toString()));
    }
}

