/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import commoble.morered.HexidecrubrometerBlock;
import commoble.morered.ObjectNames;
import commoble.morered.ServerConfig;
import commoble.morered.SimpleRecipeSerializer;
import commoble.morered.api.ExpandedPowerSupplier;
import commoble.morered.api.MoreRedAPI;
import commoble.morered.api.WireConnector;
import commoble.morered.api.internal.APIRegistries;
import commoble.morered.api.internal.DefaultWireProperties;
import commoble.morered.bitwise_logic.BitwiseLogicPlateBlock;
import commoble.morered.bitwise_logic.ChanneledPowerStorageBlockEntity;
import commoble.morered.bitwise_logic.SingleInputBitwiseLogicPlateBlock;
import commoble.morered.bitwise_logic.TwoInputBitwiseLogicPlateBlock;
import commoble.morered.client.ClientProxy;
import commoble.morered.plate_blocks.LatchBlock;
import commoble.morered.plate_blocks.LogicFunction;
import commoble.morered.plate_blocks.LogicFunctionPlateBlock;
import commoble.morered.plate_blocks.LogicFunctions;
import commoble.morered.plate_blocks.PlateBlock;
import commoble.morered.plate_blocks.PulseGateBlock;
import commoble.morered.soldering.SolderingMenu;
import commoble.morered.soldering.SolderingRecipe;
import commoble.morered.soldering.SolderingRecipeButtonPacket;
import commoble.morered.soldering.SolderingTableBlock;
import commoble.morered.wire_post.BundledCablePostBlock;
import commoble.morered.wire_post.BundledCablePostBlockEntity;
import commoble.morered.wire_post.BundledCableRelayPlateBlock;
import commoble.morered.wire_post.BundledCableRelayPlateBlockEntity;
import commoble.morered.wire_post.FakeStateLevel;
import commoble.morered.wire_post.SlackInterpolator;
import commoble.morered.wire_post.SyncPostsInChunkPacket;
import commoble.morered.wire_post.WireBreakPacket;
import commoble.morered.wire_post.WirePostBlock;
import commoble.morered.wire_post.WirePostBlockEntity;
import commoble.morered.wire_post.WirePostPlateBlock;
import commoble.morered.wire_post.WireSpoolItem;
import commoble.morered.wires.AbstractWireBlock;
import commoble.morered.wires.BundledCableBlock;
import commoble.morered.wires.BundledCableBlockEntity;
import commoble.morered.wires.ColoredCableBlock;
import commoble.morered.wires.ColoredCableBlockEntity;
import commoble.morered.wires.RedAlloyWireBlock;
import commoble.morered.wires.WireBlockEntity;
import commoble.morered.wires.WireBlockItem;
import commoble.morered.wires.WireCountLootFunction;
import commoble.morered.wires.WireUpdateBuffer;
import commoble.morered.wires.WireUpdatePacket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="morered")
public class MoreRed {
    public static final String MODID = "morered";
    public static final Logger LOGGER = LogManager.getLogger();
    private static MoreRed instance;
    public final Map<ResourceLocation, DeferredHolder<Block, ? extends LogicFunctionPlateBlock>> logicPlates = new HashMap<ResourceLocation, DeferredHolder<Block, ? extends LogicFunctionPlateBlock>>();
    public final Map<ResourceLocation, DeferredHolder<Block, ? extends BitwiseLogicPlateBlock>> bitwiseLogicPlates = new HashMap<ResourceLocation, DeferredHolder<Block, ? extends BitwiseLogicPlateBlock>>();
    public final DeferredHolder<Block, SolderingTableBlock> solderingTableBlock;
    public final DeferredHolder<Block, PlateBlock> stonePlateBlock;
    public final DeferredHolder<Block, LatchBlock> latchBlock;
    public final DeferredHolder<Block, PulseGateBlock> pulseGateBlock;
    public final DeferredHolder<Block, WirePostBlock> redwirePostBlock;
    public final DeferredHolder<Block, WirePostPlateBlock> redwirePostPlateBlock;
    public final DeferredHolder<Block, WirePostPlateBlock> redwirePostRelayPlateBlock;
    public final DeferredHolder<Block, HexidecrubrometerBlock> hexidecrubrometerBlock;
    public final DeferredHolder<Block, RedAlloyWireBlock> redAlloyWireBlock;
    public final DeferredHolder<Block, ColoredCableBlock>[] networkCableBlocks;
    public final DeferredHolder<Block, BundledCableBlock> bundledNetworkCableBlock;
    public final DeferredHolder<Block, BundledCablePostBlock> bundledCablePostBlock;
    public final DeferredHolder<Block, BundledCableRelayPlateBlock> bundledCableRelayPlateBlock;
    public final DeferredHolder<Item, WireSpoolItem> redwireSpoolItem;
    public final DeferredHolder<Item, Item> bundledCableSpoolItem;
    public final DeferredHolder<Item, Item> redAlloyIngotItem;
    public final DeferredHolder<CreativeModeTab, CreativeModeTab> tab;
    public final DeferredHolder<BlockEntityType<?>, BlockEntityType<WirePostBlockEntity>> redwirePostBeType;
    public final DeferredHolder<BlockEntityType<?>, BlockEntityType<WireBlockEntity>> wireBeType;
    public final DeferredHolder<BlockEntityType<?>, BlockEntityType<ColoredCableBlockEntity>> coloredNetworkCableBeType;
    public final DeferredHolder<BlockEntityType<?>, BlockEntityType<BundledCableBlockEntity>> bundledNetworkCableBeType;
    public final DeferredHolder<BlockEntityType<?>, BlockEntityType<BundledCablePostBlockEntity>> bundledCablePostBeType;
    public final DeferredHolder<BlockEntityType<?>, BlockEntityType<BundledCableRelayPlateBlockEntity>> bundledCableRelayPlateBeType;
    public final DeferredHolder<BlockEntityType<?>, BlockEntityType<ChanneledPowerStorageBlockEntity>> bitwiseLogicGateBeType;
    public final DeferredHolder<MenuType<?>, MenuType<SolderingMenu>> solderingMenuType;
    public final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<SolderingRecipe>> solderingSerializer;
    public final DeferredHolder<RecipeType<?>, RecipeType<SolderingRecipe>> solderingRecipeType;
    public final DeferredHolder<LootItemFunctionType<?>, LootItemFunctionType<WireCountLootFunction>> wireCountLootFunction;
    public final DeferredHolder<AttachmentType<?>, AttachmentType<Set<BlockPos>>> postsInChunkAttachment;
    public final DeferredHolder<AttachmentType<?>, AttachmentType<Map<BlockPos, VoxelShape>>> voxelCacheAttachment;
    public final DeferredHolder<DataComponentType<?>, DataComponentType<BlockPos>> spooledPostComponent;

    public static MoreRed get() {
        return instance;
    }

    public static ResourceLocation getModRL(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name);
    }

    public MoreRed(IEventBus modBus) {
        instance = this;
        IEventBus forgeBus = NeoForge.EVENT_BUS;
        DeferredRegister blocks = MoreRed.createDeferredRegister(modBus, Registries.BLOCK);
        DeferredRegister items = MoreRed.createDeferredRegister(modBus, Registries.ITEM);
        DeferredRegister tabs = MoreRed.createDeferredRegister(modBus, Registries.CREATIVE_MODE_TAB);
        DeferredRegister blockEntityTypes = MoreRed.createDeferredRegister(modBus, Registries.BLOCK_ENTITY_TYPE);
        DeferredRegister menuTypes = MoreRed.createDeferredRegister(modBus, Registries.MENU);
        DeferredRegister recipeSerializers = MoreRed.createDeferredRegister(modBus, Registries.RECIPE_SERIALIZER);
        DeferredRegister recipeTypes = MoreRed.createDeferredRegister(modBus, Registries.RECIPE_TYPE);
        DeferredRegister lootFunctions = MoreRed.createDeferredRegister(modBus, Registries.LOOT_FUNCTION_TYPE);
        DeferredRegister attachmentTypes = MoreRed.createDeferredRegister(modBus, NeoForgeRegistries.Keys.ATTACHMENT_TYPES);
        DeferredRegister dataComponentTypes = MoreRed.createDeferredRegister(modBus, Registries.DATA_COMPONENT_TYPE);
        this.solderingTableBlock = MoreRed.registerBlockItem(blocks, items, "soldering_table", () -> new SolderingTableBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(3.5f).noOcclusion()));
        this.stonePlateBlock = MoreRed.registerBlockItem(blocks, items, "stone_plate", () -> new PlateBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f).sound(SoundType.WOOD)));
        this.latchBlock = MoreRed.registerBlockItem(blocks, items, "latch", () -> new LatchBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(0.0f).sound(SoundType.WOOD)));
        this.pulseGateBlock = MoreRed.registerBlockItem(blocks, items, "pulse_gate", () -> new PulseGateBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(0.0f).sound(SoundType.WOOD)));
        this.redwirePostBlock = MoreRed.registerBlockItem(blocks, items, "redwire_post", () -> new WirePostBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 5.0f), WirePostBlock::getRedstoneConnectionDirections));
        this.redwirePostPlateBlock = MoreRed.registerBlockItem(blocks, items, "redwire_post_plate", () -> new WirePostPlateBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 5.0f), WirePostPlateBlock::getRedstoneConnectionDirectionsForEmptyPlate));
        this.redwirePostRelayPlateBlock = MoreRed.registerBlockItem(blocks, items, "redwire_post_relay_plate", () -> new WirePostPlateBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 5.0f), WirePostPlateBlock::getRedstoneConnectionDirectionsForRelayPlate));
        this.hexidecrubrometerBlock = MoreRed.registerBlockItem(blocks, items, "hexidecrubrometer", () -> new HexidecrubrometerBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 5.0f)));
        this.bundledCablePostBlock = MoreRed.registerBlockItem(blocks, items, "bundled_cable_post", () -> new BundledCablePostBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 5.0f)));
        this.bundledCableRelayPlateBlock = MoreRed.registerBlockItem(blocks, items, "bundled_cable_relay_plate", () -> new BundledCableRelayPlateBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 5.0f)));
        this.redAlloyWireBlock = MoreRed.registerBlockItem(blocks, items, "red_alloy_wire", () -> new RedAlloyWireBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).pushReaction(PushReaction.DESTROY).noCollission().instabreak()), block -> new WireBlockItem((Block)block, new Item.Properties()));
        this.networkCableBlocks = (DeferredHolder[])Util.make((Object)new DeferredHolder[16], array -> Arrays.setAll(array, i -> MoreRed.registerBlockItem((DeferredRegister<Block>)blocks, (DeferredRegister<Item>)items, ObjectNames.NETWORK_CABLES_BY_COLOR[i], () -> new ColoredCableBlock(BlockBehaviour.Properties.of().mapColor(DyeColor.values()[i]).pushReaction(PushReaction.DESTROY).noCollission().instabreak(), DyeColor.values()[i]), block -> new WireBlockItem((Block)block, new Item.Properties()))));
        this.bundledNetworkCableBlock = MoreRed.registerBlockItem(blocks, items, "bundled_network_cable", () -> new BundledCableBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).pushReaction(PushReaction.DESTROY).noCollission().instabreak()), block -> new WireBlockItem((Block)block, new Item.Properties()));
        this.registerLogicGateType(blocks, items, "diode", LogicFunctions.INPUT_B, LogicFunctionPlateBlock.LINEAR_INPUT);
        this.registerLogicGateType(blocks, items, "not_gate", LogicFunctions.NOT_B, LogicFunctionPlateBlock.LINEAR_INPUT);
        this.registerLogicGateType(blocks, items, "nor_gate", LogicFunctions.NOR, LogicFunctionPlateBlock.THREE_INPUTS);
        this.registerLogicGateType(blocks, items, "nand_gate", LogicFunctions.NAND, LogicFunctionPlateBlock.THREE_INPUTS);
        this.registerLogicGateType(blocks, items, "or_gate", LogicFunctions.OR, LogicFunctionPlateBlock.THREE_INPUTS);
        this.registerLogicGateType(blocks, items, "and_gate", LogicFunctions.AND, LogicFunctionPlateBlock.THREE_INPUTS);
        this.registerLogicGateType(blocks, items, "xor_gate", LogicFunctions.XOR_AC, LogicFunctionPlateBlock.T_INPUTS);
        this.registerLogicGateType(blocks, items, "xnor_gate", LogicFunctions.XNOR_AC, LogicFunctionPlateBlock.T_INPUTS);
        this.registerLogicGateType(blocks, items, "multiplexer", LogicFunctions.MULTIPLEX, LogicFunctionPlateBlock.THREE_INPUTS);
        this.registerLogicGateType(blocks, items, "and_2_gate", LogicFunctions.AND_2, LogicFunctionPlateBlock.T_INPUTS);
        this.registerLogicGateType(blocks, items, "nand_2_gate", LogicFunctions.NAND_2, LogicFunctionPlateBlock.T_INPUTS);
        BiFunction<BlockBehaviour.Properties, LogicFunction, SingleInputBitwiseLogicPlateBlock> singleInput = SingleInputBitwiseLogicPlateBlock::new;
        BiFunction<BlockBehaviour.Properties, LogicFunction, TwoInputBitwiseLogicPlateBlock> twoInputs = TwoInputBitwiseLogicPlateBlock::new;
        this.registerBitwiseLogicGateType(blocks, items, "bitwise_diode", LogicFunctions.INPUT_B, singleInput);
        this.registerBitwiseLogicGateType(blocks, items, "bitwise_not_gate", LogicFunctions.NOT_B, singleInput);
        this.registerBitwiseLogicGateType(blocks, items, "bitwise_or_gate", LogicFunctions.OR, twoInputs);
        this.registerBitwiseLogicGateType(blocks, items, "bitwise_and_gate", LogicFunctions.AND_2, twoInputs);
        this.registerBitwiseLogicGateType(blocks, items, "bitwise_xor_gate", LogicFunctions.XOR_AC, twoInputs);
        this.registerBitwiseLogicGateType(blocks, items, "bitwise_xnor_gate", LogicFunctions.XNOR_AC, twoInputs);
        this.redwireSpoolItem = items.register("redwire_spool", () -> new WireSpoolItem(new Item.Properties().durability(64), Tags.Blocks.REDWIRE_POSTS));
        this.bundledCableSpoolItem = items.register("bundled_cable_spool", () -> new WireSpoolItem(new Item.Properties().durability(64), Tags.Blocks.BUNDLED_CABLE_POSTS));
        this.redAlloyIngotItem = items.register("red_alloy_ingot", () -> new Item(new Item.Properties()));
        ResourceLocation tabIconId = MoreRed.getModRL("nor_gate");
        this.tab = tabs.register(MODID, () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)this.logicPlates.get(tabIconId).get())).title((Component)Component.translatable((String)"itemGroup.morered")).displayItems((params, output) -> output.acceptAll(items.getEntries().stream().map(rob -> new ItemStack((ItemLike)rob.get())).toList())).build());
        this.redwirePostBeType = blockEntityTypes.register("redwire_post", () -> BlockEntityType.Builder.of(WirePostBlockEntity::new, (Block[])new Block[]{(Block)this.redwirePostBlock.get(), (Block)this.redwirePostPlateBlock.get(), (Block)this.redwirePostRelayPlateBlock.get()}).build(null));
        this.wireBeType = blockEntityTypes.register("wire", () -> BlockEntityType.Builder.of(WireBlockEntity::new, (Block[])new Block[]{(Block)this.redAlloyWireBlock.get()}).build(null));
        this.coloredNetworkCableBeType = blockEntityTypes.register("colored_network_cable", () -> BlockEntityType.Builder.of(ColoredCableBlockEntity::new, (Block[])((Block[])Arrays.stream(this.networkCableBlocks).map(DeferredHolder::get).toArray(ColoredCableBlock[]::new))).build(null));
        this.bundledNetworkCableBeType = blockEntityTypes.register("bundled_network_cable", () -> BlockEntityType.Builder.of(BundledCableBlockEntity::new, (Block[])new Block[]{(Block)this.bundledNetworkCableBlock.get()}).build(null));
        this.bundledCablePostBeType = blockEntityTypes.register("bundled_cable_post", () -> BlockEntityType.Builder.of(BundledCablePostBlockEntity::new, (Block[])new Block[]{(Block)this.bundledCablePostBlock.get()}).build(null));
        this.bundledCableRelayPlateBeType = blockEntityTypes.register("bundled_cable_relay_plate", () -> BlockEntityType.Builder.of(BundledCableRelayPlateBlockEntity::new, (Block[])new Block[]{(Block)this.bundledCableRelayPlateBlock.get()}).build(null));
        this.bitwiseLogicGateBeType = blockEntityTypes.register("bitwise_logic_plate", () -> BlockEntityType.Builder.of(ChanneledPowerStorageBlockEntity::new, (Block[])((Block[])Util.make(() -> (Block[])this.bitwiseLogicPlates.values().stream().map(rob -> (BitwiseLogicPlateBlock)((Object)((Object)((Object)((Object)rob.get()))))).toArray(Block[]::new)))).build(null));
        this.solderingMenuType = menuTypes.register("soldering_table", () -> new MenuType(SolderingMenu::getClientContainer, FeatureFlags.VANILLA_SET));
        this.solderingSerializer = recipeSerializers.register("soldering", () -> new SimpleRecipeSerializer<SolderingRecipe>(SolderingRecipe.CODEC, SolderingRecipe.STREAM_CODEC));
        this.solderingRecipeType = recipeTypes.register("soldering", () -> RecipeType.simple((ResourceLocation)MoreRed.getModRL("soldering")));
        this.wireCountLootFunction = lootFunctions.register("set_wire_count", () -> new LootItemFunctionType(WireCountLootFunction.CODEC));
        this.postsInChunkAttachment = attachmentTypes.register("posts_in_chunk", () -> AttachmentType.builder(() -> new HashSet()).serialize(BlockPos.CODEC.listOf().xmap(HashSet::new, List::copyOf)).build());
        this.voxelCacheAttachment = attachmentTypes.register("voxel_cache", () -> AttachmentType.builder(() -> new HashMap()).build());
        this.spooledPostComponent = dataComponentTypes.register("spooled_post", () -> DataComponentType.builder().networkSynchronized(BlockPos.STREAM_CODEC).build());
        ServerConfig.initServerConfig();
        modBus.addListener(EventPriority.HIGH, this::onHighPriorityCommonSetup);
        modBus.addListener(this::onLoadComplete);
        modBus.addListener(this::onRegisterCapabilities);
        modBus.addListener(this::onRegisterPackets);
        forgeBus.addListener(EventPriority.LOW, this::onUseItemOnBlock);
        forgeBus.addListener(EventPriority.LOW, this::onLeftClickBlock);
        forgeBus.addListener(this::onLevelTickEnd);
        forgeBus.addListener(this::onUseItemOnBlock);
        forgeBus.addListener(this::onChunkWatch);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientProxy.addClientListeners(modBus, forgeBus);
        }
    }

    private void onHighPriorityCommonSetup(FMLCommonSetupEvent event) {
        Map<Block, WireConnector> wireConnectors = MoreRedAPI.getWireConnectabilityRegistry();
        Map<Block, ExpandedPowerSupplier> expandedPowerSuppliers = MoreRedAPI.getExpandedPowerRegistry();
        Map<Block, WireConnector> cableConnectors = MoreRedAPI.getCableConnectabilityRegistry();
        wireConnectors.put(Blocks.REDSTONE_WIRE, DefaultWireProperties::isRedstoneWireConnectable);
        RedAlloyWireBlock redWireBlock = (RedAlloyWireBlock)((Object)this.redAlloyWireBlock.get());
        wireConnectors.put(redWireBlock, AbstractWireBlock::canWireConnectToAdjacentWireOrCable);
        expandedPowerSuppliers.put(redWireBlock, redWireBlock::getExpandedPower);
        for (int i = 0; i < 16; ++i) {
            ColoredCableBlock coloredCableBlock = (ColoredCableBlock)((Object)this.networkCableBlocks[i].get());
            wireConnectors.put(coloredCableBlock, coloredCableBlock::canConnectToAdjacentWireOrCable);
            expandedPowerSuppliers.put(coloredCableBlock, coloredCableBlock::getExpandedPower);
            cableConnectors.put(coloredCableBlock, coloredCableBlock::canConnectToAdjacentWireOrCable);
        }
        BundledCableBlock bundledCableBlock = (BundledCableBlock)((Object)this.bundledNetworkCableBlock.get());
        cableConnectors.put(bundledCableBlock, AbstractWireBlock::canWireConnectToAdjacentWireOrCable);
        BundledCableRelayPlateBlock cablePlateBlock = (BundledCableRelayPlateBlock)((Object)this.bundledCableRelayPlateBlock.get());
        cableConnectors.put(cablePlateBlock, cablePlateBlock::canConnectToAdjacentCable);
        this.bitwiseLogicPlates.values().stream().map(rob -> (BitwiseLogicPlateBlock)((Object)((Object)rob.get()))).forEach(block -> cableConnectors.put((Block)block, (world, thisPos, thisState, wirePos, wireState, wireFace, directionToWire) -> block.canConnectToAdjacentCable(world, thisPos, thisState, wirePos, wireState, wireFace, directionToWire)));
    }

    private void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(MoreRedAPI.CHANNELED_POWER_CAPABILITY, (BlockEntityType)this.coloredNetworkCableBeType.get(), (be, side) -> be.getChanneledPower((Direction)side));
        event.registerBlockEntity(MoreRedAPI.CHANNELED_POWER_CAPABILITY, (BlockEntityType)this.bundledNetworkCableBeType.get(), (be, side) -> be.getChanneledPower((Direction)side));
        event.registerBlockEntity(MoreRedAPI.CHANNELED_POWER_CAPABILITY, (BlockEntityType)this.bundledCableRelayPlateBeType.get(), (be, side) -> be.getChanneledPower((Direction)side));
        event.registerBlockEntity(MoreRedAPI.CHANNELED_POWER_CAPABILITY, (BlockEntityType)this.bitwiseLogicGateBeType.get(), (be, side) -> be.getChanneledPower((Direction)side));
    }

    private void onRegisterPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar r = event.registrar("6.0.0");
        r.playToServer(SolderingRecipeButtonPacket.TYPE, SolderingRecipeButtonPacket.STREAM_CODEC, SolderingRecipeButtonPacket::handle);
        r.playToClient(WireBreakPacket.TYPE, WireBreakPacket.STREAM_CODEC, WireBreakPacket::handle);
        r.playToClient(SyncPostsInChunkPacket.TYPE, SyncPostsInChunkPacket.STREAM_CODEC, SyncPostsInChunkPacket::handle);
        r.playToClient(WireUpdatePacket.TYPE, WireUpdatePacket.STREAM_CODEC, WireUpdatePacket::handle);
    }

    private void onLoadComplete(FMLLoadCompleteEvent event) {
        APIRegistries.freezeRegistries();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onUseItemOnBlock(UseItemOnBlockEvent event) {
        block6: {
            Item item;
            UseOnContext useContext = event.getUseOnContext();
            ItemStack stack = useContext.getItemInHand();
            if (event.getUsePhase() != UseItemOnBlockEvent.UsePhase.ITEM_AFTER_BLOCK || !((item = stack.getItem()) instanceof BlockItem)) break block6;
            BlockItem blockItem = (BlockItem)item;
            Level level = useContext.getLevel();
            BlockPlaceContext placeContext = new BlockPlaceContext(useContext);
            BlockPos placePos = placeContext.getClickedPos();
            BlockState placementState = blockItem.getPlacementState(placeContext);
            if (placementState == null) {
                return;
            }
            double range = (Double)ServerConfig.INSTANCE.maxWirePostConnectionRange().get();
            ChunkPos nearbyChunkPos = new ChunkPos(placePos);
            int chunkRange = (int)Math.ceil(range / 16.0);
            HashSet<ChunkPos> chunkPositions = new HashSet<ChunkPos>();
            for (int xOff = -chunkRange; xOff <= chunkRange; ++xOff) {
                for (int zOff = -chunkRange; zOff <= chunkRange; ++zOff) {
                    chunkPositions.add(new ChunkPos(nearbyChunkPos.x + xOff, nearbyChunkPos.z + zOff));
                }
            }
            for (ChunkPos chunkPos : chunkPositions) {
                LevelChunk chunk;
                Set posts;
                if (!level.hasChunkAt(chunkPos.getWorldPosition()) || (posts = (Set)(chunk = level.getChunk(chunkPos.x, chunkPos.z)).getData((AttachmentType)this.postsInChunkAttachment.get())) == null) continue;
                HashSet<BlockPos> checkedPostPositions = new HashSet<BlockPos>();
                for (BlockPos postPos : posts) {
                    Player player;
                    block9: {
                        block7: {
                            Vec3 hit;
                            block8: {
                                BlockEntity be = level.getBlockEntity(postPos);
                                if (!(be instanceof WirePostBlockEntity)) continue;
                                WirePostBlockEntity wire = (WirePostBlockEntity)be;
                                hit = SlackInterpolator.doesBlockStateIntersectAnyWireOfPost(new FakeStateLevel((BlockGetter)level, placePos, placementState), postPos, placePos, placementState, wire.getRemoteConnectionBoxes(), checkedPostPositions);
                                if (hit == null) break block7;
                                player = placeContext.getPlayer();
                                if (!(player instanceof ServerPlayer)) break block8;
                                ServerPlayer serverPlayer = (ServerPlayer)player;
                                if (!(level instanceof ServerLevel)) break block8;
                                ServerLevel serverLevel = (ServerLevel)level;
                                serverPlayer.connection.send((Packet)new ClientboundSetEquipmentPacket(serverPlayer.getId(), (List)ImmutableList.of((Object)Pair.of((Object)EquipmentSlot.MAINHAND, (Object)serverPlayer.getItemInHand(InteractionHand.MAIN_HAND)))));
                                serverLevel.sendParticles(serverPlayer, (ParticleOptions)DustParticleOptions.REDSTONE, false, hit.x, hit.y, hit.z, 5, 0.05, 0.05, 0.05, 0.0);
                                break block9;
                            }
                            if (!level.isClientSide) break block9;
                            level.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, hit.x, hit.y, hit.z, 0.05, 0.05, 0.05);
                            break block9;
                        }
                        checkedPostPositions.add(postPos.immutable());
                        continue;
                    }
                    if (player != null) {
                        player.playNotifySound(SoundEvents.WANDERING_TRADER_HURT, SoundSource.BLOCKS, 0.5f, 2.0f);
                    }
                    event.cancelWithResult(ItemInteractionResult.SUCCESS);
                    return;
                }
            }
        }
    }

    private void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getAction() != PlayerInteractEvent.LeftClickBlock.Action.START) {
            return;
        }
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (!(block instanceof AbstractWireBlock)) {
            return;
        }
        AbstractWireBlock wireBlock = (AbstractWireBlock)block;
        event.setCanceled(true);
        if (!serverPlayer.canInteractWithBlock(pos, 1.0) || pos.getY() >= serverLevel.getMaxBuildHeight() || pos.getY() < serverLevel.getMinBuildHeight() || !serverLevel.mayInteract((Player)serverPlayer, pos) || CommonHooks.fireBlockBreak((Level)serverLevel, (GameType)serverPlayer.gameMode.getGameModeForPlayer(), (ServerPlayer)serverPlayer, (BlockPos)pos, (BlockState)state).isCanceled() || serverPlayer.blockActionRestricted((Level)serverLevel, pos, serverPlayer.gameMode.getGameModeForPlayer())) {
            serverPlayer.connection.send((Packet)new ClientboundBlockUpdatePacket(pos, state));
            return;
        }
        Direction hitNormal = event.getFace();
        Direction destroySide = hitNormal.getOpposite();
        if (serverPlayer.isCreative()) {
            wireBlock.destroyClickedSegment(state, (Level)serverLevel, pos, (Player)serverPlayer, destroySide, false);
            return;
        }
        if (!state.canHarvestBlock((BlockGetter)serverLevel, pos, (Player)serverPlayer)) {
            serverPlayer.connection.send((Packet)new ClientboundBlockUpdatePacket(pos, state));
            return;
        }
        wireBlock.destroyClickedSegment(state, (Level)serverLevel, pos, (Player)serverPlayer, destroySide, true);
    }

    private void onLevelTickEnd(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            WireUpdateBuffer.get(serverLevel).sendPackets(serverLevel);
        }
    }

    private void onChunkWatch(ChunkWatchEvent.Watch event) {
        ServerPlayer player = event.getPlayer();
        LevelChunk chunk = event.getChunk();
        ChunkPos pos = chunk.getPos();
        Set postsInChunk = (Set)chunk.getData((AttachmentType)this.postsInChunkAttachment.get());
        if (postsInChunk != null && !postsInChunk.isEmpty()) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncPostsInChunkPacket(pos, postsInChunk), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static <T> DeferredRegister<T> createDeferredRegister(IEventBus modBus, ResourceKey<Registry<T>> registryKey) {
        DeferredRegister reg = DeferredRegister.create(registryKey, (String)MODID);
        reg.register(modBus);
        return reg;
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> DeferredHolder<Block, BLOCK> registerBlockItem(DeferredRegister<Block> blocks, DeferredRegister<Item> items, String name, Supplier<? extends BLOCK> blockFactory, Function<? super BLOCK, ? extends ITEM> itemFactory) {
        DeferredHolder block = blocks.register(name, blockFactory);
        items.register(name, () -> (BlockItem)itemFactory.apply((Object)block.get()));
        return block;
    }

    private static <BLOCK extends Block> DeferredHolder<Block, BLOCK> registerBlockItem(DeferredRegister<Block> blocks, DeferredRegister<Item> items, String name, Supplier<? extends BLOCK> blockFactory) {
        return MoreRed.registerBlockItem(blocks, items, name, blockFactory, block -> new BlockItem(block, new Item.Properties()));
    }

    public DeferredHolder<Block, LogicFunctionPlateBlock> registerLogicGateType(DeferredRegister<Block> blocks, DeferredRegister<Item> items, String name, LogicFunction function, LogicFunctionPlateBlock.LogicFunctionPlateBlockFactory factory) {
        Supplier<LogicFunctionPlateBlock> blockFactory = () -> factory.makeBlock(function, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(0.0f).sound(SoundType.WOOD));
        DeferredHolder<Block, LogicFunctionPlateBlock> blockGetter = MoreRed.registerBlockItem(blocks, items, name, blockFactory);
        this.logicPlates.put(blockGetter.getId(), blockGetter);
        return blockGetter;
    }

    public <B extends BitwiseLogicPlateBlock> DeferredHolder<Block, B> registerBitwiseLogicGateType(DeferredRegister<Block> blocks, DeferredRegister<Item> items, String name, LogicFunction function, BiFunction<BlockBehaviour.Properties, LogicFunction, B> blockFactory) {
        Supplier<BitwiseLogicPlateBlock> actualBlockFactory = () -> (BitwiseLogicPlateBlock)((Object)((Object)blockFactory.apply(BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instrument(NoteBlockInstrument.BASEDRUM).strength(0.0f).sound(SoundType.WOOD), function)));
        DeferredHolder<Block, BitwiseLogicPlateBlock> rob = MoreRed.registerBlockItem(blocks, items, name, actualBlockFactory);
        this.bitwiseLogicPlates.put(rob.getId(), rob);
        return rob;
    }

    public static class Tags {

        public static class Items {
            public static final TagKey<Item> BUNDLED_NETWORK_CABLES = Items.tag("bundled_network_cables");
            public static final TagKey<Item> COLORED_NETWORK_CABLES = Items.tag("colored_network_cables");
            public static final TagKey<Item> NETWORK_CABLES = Items.tag("network_cables");
            public static final TagKey<Item> RED_ALLOY_WIRES = Items.tag("red_alloy_wires");
            public static final TagKey<Item> RED_ALLOYABLE_INGOTS = Items.tag("red_alloyable_ingots");

            private static TagKey<Item> tag(String name) {
                return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)MoreRed.getModRL(name));
            }
        }

        public static class Blocks {
            public static final TagKey<Block> REDWIRE_POSTS = Blocks.tag("redwire_posts");
            public static final TagKey<Block> BUNDLED_CABLE_POSTS = Blocks.tag("bundled_cable_posts");

            private static TagKey<Block> tag(String name) {
                return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)MoreRed.getModRL(name));
            }
        }
    }
}

