/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.processor;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.world.BlockLogicUtil;
import com.aetherteam.aether.world.processor.AetherStructureProcessors;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

public class VerticalGradientProcessor
extends StructureProcessor {
    public static final VerticalGradientProcessor INSTANCE = new VerticalGradientProcessor();
    public static final MapCodec<VerticalGradientProcessor> CODEC = MapCodec.unit((Object)((Object)INSTANCE));

    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader level, BlockPos origin, BlockPos centerBottom, StructureTemplate.StructureBlockInfo originalBlockInfo, StructureTemplate.StructureBlockInfo modifiedBlockInfo, StructurePlaceSettings settings, @Nullable StructureTemplate template) {
        if (level instanceof WorldGenLevel) {
            RandomSource random;
            BlockPos below;
            WorldGenLevel worldGenLevel = (WorldGenLevel)level;
            if (worldGenLevel instanceof WorldGenRegion) {
                WorldGenRegion region = (WorldGenRegion)worldGenLevel;
                if (BlockLogicUtil.isOutOfBounds(modifiedBlockInfo.pos(), region.getCenter())) {
                    return modifiedBlockInfo;
                }
            }
            if (modifiedBlockInfo.state().is((Block)AetherBlocks.AETHER_DIRT.get()) && worldGenLevel.getBlockState(below = modifiedBlockInfo.pos().below()).is(AetherTags.Blocks.HOLYSTONE) && (random = settings.getRandom(below)).nextBoolean()) {
                worldGenLevel.setBlock(below, ((Block)AetherBlocks.AETHER_DIRT.get()).defaultBlockState(), 2);
            }
        }
        return modifiedBlockInfo;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)AetherStructureProcessors.VERTICAL_GRADIENT.get();
    }
}

