/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.network.packet.serverbound;

import com.aetherteam.aether.perk.data.ServerPerkData;
import com.aetherteam.aether.perk.types.Halo;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerHaloPacket {

    public record Remove(UUID playerUUID) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<Remove> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"remove_halo_server"));
        public static final StreamCodec<RegistryFriendlyByteBuf, Remove> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, Remove::playerUUID, Remove::new);

        public CustomPacketPayload.Type<Remove> type() {
            return TYPE;
        }

        public static void execute(Remove payload, IPayloadContext context) {
            Player playerEntity = context.player();
            if (playerEntity.getServer() != null && payload.playerUUID() != null) {
                ServerPerkData.HALO_INSTANCE.removePerk(playerEntity.getServer(), payload.playerUUID());
            }
        }
    }

    public record Apply(UUID playerUUID, Halo halo) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<Apply> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"add_halo_server"));
        public static final StreamCodec<RegistryFriendlyByteBuf, Apply> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, Apply::playerUUID, Halo.STREAM_CODEC, Apply::halo, Apply::new);

        public CustomPacketPayload.Type<Apply> type() {
            return TYPE;
        }

        public static void execute(Apply payload, IPayloadContext context) {
            Player playerEntity = context.player();
            if (playerEntity.getServer() != null && payload.playerUUID() != null && payload.halo() != null) {
                ServerPerkData.HALO_INSTANCE.applyPerkWithVerification(playerEntity.getServer(), payload.playerUUID(), payload.halo());
            }
        }
    }
}

