/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.projectile.crystal;

import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.particle.AetherParticleTypes;
import com.aetherteam.aether.data.resources.registries.AetherDamageTypes;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.projectile.crystal.AbstractCrystal;
import com.aetherteam.aether.entity.projectile.crystal.WeaknessDamage;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class IceCrystal
extends AbstractCrystal
implements WeaknessDamage {
    private double xPower;
    private double zPower;
    private boolean attacked = false;

    public IceCrystal(EntityType<? extends IceCrystal> entityType, Level level) {
        super(entityType, level);
    }

    public IceCrystal(Level level, Entity shooter) {
        this((EntityType<? extends IceCrystal>)((EntityType)AetherEntityTypes.ICE_CRYSTAL.get()), level);
        this.setOwner(shooter);
        this.setPos(shooter.getX(), shooter.getY(), shooter.getZ());
        float rotation = this.random.nextFloat() * 360.0f;
        this.xPower = (double)Mth.sin((float)rotation) * 0.2;
        this.zPower = (double)(-Mth.cos((float)rotation)) * 0.2;
        this.setDeltaMovement(this.xPower, 0.0, this.zPower);
    }

    protected void onHitEntity(EntityHitResult result) {
        this.doDamage(result.getEntity());
    }

    protected void onHitBlock(BlockHitResult result) {
        if (this.attacked) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), this.getImpactExplosionSoundEvent(), SoundSource.HOSTILE, 2.0f, this.random.nextFloat() - this.random.nextFloat() * 0.2f + 1.2f);
            if (!this.level().isClientSide()) {
                this.discard();
            }
        } else {
            this.markHurt();
            switch (result.getDirection()) {
                case NORTH: 
                case SOUTH: {
                    this.zPower = -this.zPower;
                    break;
                }
                case WEST: 
                case EAST: {
                    this.xPower = -this.xPower;
                }
            }
            this.setDeltaMovement(this.xPower, 0.0, this.zPower);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        this.markHurt();
        Entity entity = source.getEntity();
        if (entity != null) {
            if (!this.level().isClientSide()) {
                Vec3 vec3 = entity.getLookAngle();
                this.xPower = vec3.x() * 2.5;
                this.zPower = vec3.z() * 2.5;
                this.setDeltaMovement(this.xPower, 0.0, this.zPower);
                this.setOwner(entity);
                this.attacked = true;
            }
            return true;
        }
        return false;
    }

    public void doDamage(Entity entity) {
        LivingEntity livingEntity;
        if (this.getOwner() != entity && entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).hurt(AetherDamageTypes.indirectEntityDamageSource(this.level(), AetherDamageTypes.ICE_CRYSTAL, (Entity)this, this.getOwner()), 7.0f)) {
            WeaknessDamage.super.damageWithWeakness(this, livingEntity, this.random);
        }
    }

    @Override
    public int getLifeSpan() {
        return 500;
    }

    @Override
    protected ParticleOptions getExplosionParticle() {
        return (ParticleOptions)AetherParticleTypes.FROZEN.get();
    }

    @Override
    @Nullable
    public SoundEvent getImpactExplosionSoundEvent() {
        return (SoundEvent)AetherSoundEvents.ENTITY_ICE_CRYSTAL_EXPLODE.get();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putDouble("XSpeed", this.xPower);
        tag.putDouble("ZSpeed", this.zPower);
        tag.putBoolean("Attacked", this.attacked);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.xPower = tag.getDouble("XSpeed");
        this.zPower = tag.getDouble("ZSpeed");
        this.attacked = tag.getBoolean("Attacked");
    }
}

