/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.ai.goal;

import javax.annotation.Nullable;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class FallingRandomStrollGoal
extends RandomStrollGoal {
    private final float probability;

    public FallingRandomStrollGoal(PathfinderMob mob, double speed) {
        this(mob, speed, 120, 0.001f);
    }

    public FallingRandomStrollGoal(PathfinderMob mob, double speed, int interval) {
        this(mob, speed, interval, 0.001f);
    }

    public FallingRandomStrollGoal(PathfinderMob mob, double speed, int interval, float probability) {
        super(mob, speed, interval);
        this.probability = probability;
    }

    @Nullable
    protected Vec3 getPosition() {
        if (this.mob.isInWaterOrBubble()) {
            Vec3 vec3 = LandRandomPos.getPos((PathfinderMob)this.mob, (int)15, (int)this.mob.getMaxFallDistance());
            return vec3 == null ? super.getPosition() : vec3;
        }
        if (!this.mob.onGround()) {
            Vec3 vec3 = LandRandomPos.getPos((PathfinderMob)this.mob, (int)12, (int)this.mob.getMaxFallDistance());
            return vec3 != null ? vec3 : super.getPosition();
        }
        return this.mob.getRandom().nextFloat() >= this.probability ? LandRandomPos.getPos((PathfinderMob)this.mob, (int)10, (int)this.mob.getMaxFallDistance()) : super.getPosition();
    }
}

