/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.command;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherTimeAttachment;
import com.aetherteam.nitrogen.attachment.INBTSynchable;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class EternalDayCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"aether").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"eternal_day").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(Commands.literal((String)"set").then(Commands.argument((String)"option", (ArgumentType)BoolArgumentType.bool()).suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)BoolArgumentType.bool().getExamples(), (SuggestionsBuilder)builder)).executes(context -> EternalDayCommand.setEternalDay((CommandSourceStack)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"option")))))).then(Commands.literal((String)"query").executes(context -> EternalDayCommand.queryEternalDay((CommandSourceStack)context.getSource())))));
    }

    private static int setEternalDay(CommandSourceStack source, boolean value) {
        ServerLevel level = source.getLevel();
        if (level.hasData(AetherDataAttachments.AETHER_TIME)) {
            AetherTimeAttachment data = (AetherTimeAttachment)level.getData(AetherDataAttachments.AETHER_TIME);
            data.setEternalDay(value);
            data.updateEternalDay((Level)level);
            if (((Boolean)AetherConfig.SERVER.sync_aether_time.get()).booleanValue()) {
                data.setSynched(-1, INBTSynchable.Direction.DIMENSION, "setShouldWait", true, level);
            }
            source.sendSuccess(() -> Component.translatable((String)"commands.aether.capability.time.eternal_day.set", (Object[])new Object[]{value}), true);
        }
        return 1;
    }

    private static int queryEternalDay(CommandSourceStack source) {
        ServerLevel level = source.getLevel();
        if (level.hasData(AetherDataAttachments.AETHER_TIME)) {
            source.sendSuccess(() -> Component.translatable((String)"commands.aether.capability.time.eternal_day.query", (Object[])new Object[]{((AetherTimeAttachment)level.getData(AetherDataAttachments.AETHER_TIME)).isEternalDay()}), true);
        }
        return 1;
    }
}

