/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block.portal;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.block.portal.AetherPortalBlock;
import com.aetherteam.aether.network.packet.clientbound.PortalTravelSoundPacket;
import com.aetherteam.aether.world.AetherPoi;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.DimensionTransition;
import net.neoforged.neoforge.network.PacketDistributor;

public class AetherPortalForcer {
    public static final DimensionTransition.PostDimensionTransition PLAY_PORTAL_SOUND = AetherPortalForcer::playPortalSound;
    private final ServerLevel level;

    public AetherPortalForcer(ServerLevel level) {
        this.level = level;
    }

    private static void playPortalSound(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            PacketDistributor.sendToPlayer((ServerPlayer)serverplayer, (CustomPacketPayload)new PortalTravelSoundPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public Optional<BlockPos> findClosestPortalPosition(BlockPos pExitPos, WorldBorder pWorldBorder) {
        PoiManager poimanager = this.level.getPoiManager();
        int i = 128;
        poimanager.ensureLoadedAndValid((LevelReader)this.level, pExitPos, i);
        return poimanager.getInSquare(p_230634_ -> p_230634_.is(AetherPoi.AETHER_PORTAL), pExitPos, i, PoiManager.Occupancy.ANY).map(PoiRecord::getPos).filter(arg_0 -> ((WorldBorder)pWorldBorder).isWithinBounds(arg_0)).filter(p_352047_ -> this.level.getBlockState(p_352047_).hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)).min(Comparator.comparingDouble(p_352046_ -> p_352046_.distSqr((Vec3i)pExitPos)).thenComparingInt(Vec3i::getY));
    }

    public Optional<BlockUtil.FoundRectangle> createPortal(BlockPos pos, Direction.Axis axis) {
        Direction direction = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        double d0 = -1.0;
        BlockPos blockPos = null;
        double d1 = -1.0;
        BlockPos blockPos1 = null;
        WorldBorder worldBorder = this.level.getWorldBorder();
        int i = Math.min(this.level.getMaxBuildHeight(), this.level.getMinBuildHeight() + this.level.getLogicalHeight()) - 1;
        BlockPos.MutableBlockPos mutablePos = pos.mutable();
        for (BlockPos.MutableBlockPos mutablePos1 : BlockPos.spiralAround((BlockPos)pos, (int)64, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int j = Math.min(i, this.level.getHeight(Heightmap.Types.MOTION_BLOCKING, mutablePos1.getX(), mutablePos1.getZ()));
            if (!worldBorder.isWithinBounds((BlockPos)mutablePos1) || !worldBorder.isWithinBounds((BlockPos)mutablePos1.move(direction, 1))) continue;
            mutablePos1.move(direction.getOpposite(), 1);
            for (int l = j; l >= this.level.getMinBuildHeight(); --l) {
                int j1;
                mutablePos1.setY(l);
                if (!this.level.isEmptyBlock((BlockPos)mutablePos1)) continue;
                int i1 = l;
                while (l > this.level.getMinBuildHeight() && this.level.isEmptyBlock((BlockPos)mutablePos1.move(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > i || (j1 = i1 - l) > 0 && j1 < 3) continue;
                mutablePos1.setY(l);
                if (!this.canHostFrame((BlockPos)mutablePos1, mutablePos, direction, 0)) continue;
                double d2 = pos.distSqr((Vec3i)mutablePos1);
                if (this.canHostFrame((BlockPos)mutablePos1, mutablePos, direction, -1) && this.canHostFrame((BlockPos)mutablePos1, mutablePos, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockPos = mutablePos1.immutable();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockPos1 = mutablePos1.immutable();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockPos = blockPos1;
            d0 = d1;
        }
        if (d0 == -1.0) {
            int i2 = i - 9;
            int k1 = Math.max(this.level.getMinBuildHeight() + 1, 70);
            if (i2 < k1) {
                return Optional.empty();
            }
            blockPos = new BlockPos(pos.getX(), Mth.clamp((int)pos.getY(), (int)k1, (int)i2), pos.getZ()).immutable();
            Direction direction1 = direction.getClockWise();
            if (!worldBorder.isWithinBounds(blockPos)) {
                return Optional.empty();
            }
            for (int i3 = -1; i3 < 2; ++i3) {
                for (int j3 = 0; j3 < 2; ++j3) {
                    for (int k3 = -1; k3 < 3; ++k3) {
                        BlockState blockState1 = k3 < 0 ? Blocks.GLOWSTONE.defaultBlockState() : Blocks.AIR.defaultBlockState();
                        mutablePos.setWithOffset((Vec3i)blockPos, j3 * direction.getStepX() + i3 * direction1.getStepX(), k3, j3 * direction.getStepZ() + i3 * direction1.getStepZ());
                        this.level.setBlockAndUpdate((BlockPos)mutablePos, blockState1);
                    }
                }
            }
        }
        for (int l1 = -1; l1 < 3; ++l1) {
            for (int j2 = -1; j2 < 4; ++j2) {
                if (l1 != -1 && l1 != 2 && j2 != -1 && j2 != 3) continue;
                mutablePos.setWithOffset(blockPos, l1 * direction.getStepX(), j2, l1 * direction.getStepZ());
                this.level.setBlock((BlockPos)mutablePos, Blocks.GLOWSTONE.defaultBlockState(), 3);
            }
        }
        BlockState blockState = (BlockState)((AetherPortalBlock)((Object)AetherBlocks.AETHER_PORTAL.get())).defaultBlockState().setValue(AetherPortalBlock.AXIS, (Comparable)axis);
        for (int k2 = 0; k2 < 2; ++k2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                mutablePos.setWithOffset((Vec3i)blockPos, k2 * direction.getStepX(), l2, k2 * direction.getStepZ());
                this.level.setBlock((BlockPos)mutablePos, blockState, 18);
            }
        }
        return Optional.of(new BlockUtil.FoundRectangle(blockPos.immutable(), 2, 3));
    }

    private boolean canHostFrame(BlockPos originalPos, BlockPos.MutableBlockPos offsetPos, Direction direction, int offsetScale) {
        Direction clockWiseDirection = direction.getClockWise();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                offsetPos.setWithOffset((Vec3i)originalPos, direction.getStepX() * i + clockWiseDirection.getStepX() * offsetScale, j, direction.getStepZ() * i + clockWiseDirection.getStepZ() * offsetScale);
                BlockState blockState = this.level.getBlockState((BlockPos)offsetPos);
                if (j < 0 && (blockState.isAir() || blockState.is(AetherTags.Blocks.AETHER_PORTAL_BLACKLIST))) {
                    return false;
                }
                if (j < 0 || this.level.isEmptyBlock((BlockPos)offsetPos)) continue;
                return false;
            }
        }
        return true;
    }
}

