/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.unification.worldgen;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.AlmostUnified;
import com.almostreliable.unified.api.unification.UnificationEntry;
import com.almostreliable.unified.api.unification.UnificationLookup;
import com.almostreliable.unified.mixin.neoforge.worldgen.OreConfigurationAccessor;
import com.almostreliable.unified.utils.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class WorldGenUnifier {
    public static final ResourceLocation UNKNOWN_FEATURE_ID = Utils.getRL("unknown_feature_id");
    private final Registry<ConfiguredFeature<?, ?>> cfRegistry;
    private final Set<Holder.Reference<ConfiguredFeature<?, ?>>> featuresToRemove = new HashSet();

    public WorldGenUnifier(RegistryAccess registryAccess) {
        this.cfRegistry = registryAccess.registryOrThrow(Registries.CONFIGURED_FEATURE);
    }

    public void process() {
        UnificationLookup unificationLookup = AlmostUnified.INSTANCE.getRuntimeOrThrow().getUnificationLookup();
        this.cfRegistry.holders().forEach(holder -> {
            switch (this.handleConfiguredFeature(unificationLookup, (Holder<ConfiguredFeature<?, ?>>)holder).ordinal()) {
                case 0: {
                    break;
                }
                case 2: {
                    AlmostUnifiedCommon.LOGGER.info("[WorldGen] Mark ConfiguredFeature '{}' for removal:", (Object)holder.unwrapKey().map(ResourceKey::location).orElse(UNKNOWN_FEATURE_ID));
                    this.featuresToRemove.add((Holder.Reference<ConfiguredFeature<?, ?>>)holder);
                    break;
                }
                case 1: {
                    AlmostUnifiedCommon.LOGGER.info("[WorldGen] Changed ConfiguredFeature '{}':", (Object)holder.unwrapKey().map(ResourceKey::location).orElse(UNKNOWN_FEATURE_ID));
                }
            }
        });
    }

    private Result handleConfiguredFeature(UnificationLookup unificationLookup, Holder<ConfiguredFeature<?, ?>> cfHolder) {
        FeatureConfiguration featureConfiguration = ((ConfiguredFeature)cfHolder.value()).config();
        if (!(featureConfiguration instanceof OreConfiguration)) {
            return Result.SAME;
        }
        OreConfiguration oreConfig = (OreConfiguration)featureConfiguration;
        boolean changed = false;
        ArrayList<OreConfiguration.TargetBlockState> newTargetStates = new ArrayList<OreConfiguration.TargetBlockState>(oreConfig.targetStates);
        ListIterator it = newTargetStates.listIterator();
        while (it.hasNext()) {
            OreConfiguration.TargetBlockState currentTargetState = (OreConfiguration.TargetBlockState)it.next();
            if (!this.handleTargetState(unificationLookup, currentTargetState)) continue;
            changed = true;
            it.remove();
        }
        if (changed) {
            ((OreConfigurationAccessor)oreConfig).almostunified$setTargets(newTargetStates);
            return newTargetStates.isEmpty() ? Result.REMOVE : Result.CHANGE;
        }
        return Result.SAME;
    }

    private boolean handleTargetState(UnificationLookup unificationLookup, OreConfiguration.TargetBlockState targetState) {
        Holder blockHolder = targetState.state.getBlockHolder();
        if (!(blockHolder instanceof Holder.Reference)) {
            return false;
        }
        Holder.Reference ref = (Holder.Reference)blockHolder;
        ResourceLocation blockId = ref.key().location();
        UnificationEntry<Item> replacement = unificationLookup.getVariantItemTarget(blockId);
        if (replacement == null || replacement.id().equals((Object)blockId)) {
            return false;
        }
        Block replacementBlock = BuiltInRegistries.BLOCK.getOptional(replacement.id()).orElse(null);
        if (replacementBlock == null) {
            AlmostUnifiedCommon.LOGGER.error("Trying to find replacement for block {} (Replacement: {}), but it does not exist.", (Object)blockId, (Object)replacement.id());
            return false;
        }
        return true;
    }

    public boolean shouldRemovePlacedFeature(Holder<PlacedFeature> placedFeature) {
        Holder cfHolder = ((PlacedFeature)placedFeature.value()).feature();
        if (cfHolder instanceof Holder.Reference) {
            Holder.Reference ref = (Holder.Reference)cfHolder;
            return this.featuresToRemove.contains(ref);
        }
        return false;
    }

    private static enum Result {
        SAME,
        CHANGE,
        REMOVE;

    }
}

