/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.entity.model;

import com.google.common.collect.ImmutableList;
import com.teammetallurgy.aquaculture.entity.TurtleLandEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class TurtleLandModel<T extends TurtleLandEntity>
extends QuadrupedModel<T> {
    private final ModelPart tail;
    private final ModelPart shellTop;
    private final ModelPart belly;

    public TurtleLandModel(ModelPart part) {
        super(part, false, 1.1f, 1.5f, 2.0f, 2.0f, 24);
        this.tail = part.getChild("tail");
        this.shellTop = part.getChild("shell_top");
        this.belly = part.getChild("belly");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition modelDefinition = new MeshDefinition();
        PartDefinition def = modelDefinition.getRoot();
        def.addOrReplaceChild("head", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)22.2f, (float)-4.0f));
        def.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -1.0f, -3.0f, 5.0f, 2.0f, 6.0f), PartPose.offset((float)0.0f, (float)22.0f, (float)0.0f));
        def.addOrReplaceChild("belly", CubeListBuilder.create().texOffs(0, 14).addBox(-2.0f, -0.5f, -2.5f, 4.0f, 1.0f, 5.0f), PartPose.offset((float)0.0f, (float)23.0f, (float)0.0f));
        def.addOrReplaceChild("shell_top", CubeListBuilder.create().texOffs(0, 8).addBox(-2.0f, -0.5f, -2.5f, 4.0f, 1.0f, 5.0f), PartPose.offset((float)0.0f, (float)20.5f, (float)0.0f));
        def.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(16, 3).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)-2.5f, (float)23.0f, (float)3.0f, (float)0.5235988f, (float)5.7595863f, (float)0.0f));
        def.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(16, 0).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)2.5f, (float)23.0f, (float)-3.0f, (float)-0.5235988f, (float)-0.5235988f, (float)0.0f));
        def.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(20, 3).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)-2.5f, (float)23.0f, (float)-3.0f, (float)-0.5235988f, (float)0.5235988f, (float)0.0f));
        def.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(20, 0).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)2.5f, (float)23.0f, (float)3.0f, (float)0.5235988f, (float)0.5235988f, (float)0.0f));
        def.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(26, 0).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)0.0f, (float)22.5f, (float)3.2f));
        return LayerDefinition.create((MeshDefinition)modelDefinition, (int)64, (int)32);
    }

    @Nonnull
    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.tail, (Object)this.shellTop, (Object)this.belly);
    }

    public void setupAnim(@Nonnull T turtle, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.rightHindLeg.xRot = 0.5235988f + Mth.cos((float)(limbSwing * 5.0f)) * 1.4f * limbSwingAmount;
        this.leftHindLeg.xRot = -0.5235988f + -(Mth.cos((float)(limbSwing * 5.0f)) * 1.4f * limbSwingAmount);
        this.rightFrontLeg.xRot = -0.5235988f + -(Mth.cos((float)(limbSwing * 5.0f)) * 1.4f * limbSwingAmount);
        this.leftFrontLeg.xRot = 0.5235988f + Mth.cos((float)(limbSwing * 5.0f)) * 1.4f * limbSwingAmount;
        this.tail.yRot = Mth.cos((float)(limbSwing * 0.4662f)) * 0.6f * limbSwingAmount;
    }
}

