/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm;

import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.chisel.ctm.Configurations;
import team.chisel.ctm.client.model.AbstractCTMBakedModel;
import team.chisel.ctm.client.model.parsing.ModelLoaderCTM;
import team.chisel.ctm.client.newctm.json.CTMDefinitionManager;
import team.chisel.ctm.client.texture.type.TextureTypeRegistry;
import team.chisel.ctm.client.util.CTMPackReloadListener;
import team.chisel.ctm.client.util.TextureMetadataHandler;

@Mod(value="ctm", dist={Dist.CLIENT})
public class CTM {
    public static final String MOD_ID = "ctm";
    public static final String MOD_NAME = "CTM";
    public static final String DOMAIN = "ctm";
    public static final Logger logger = LogManager.getLogger((String)"CTM");
    public static CTM instance;
    private final CTMDefinitionManager definitionManager;
    private final CTMPackReloadListener reloadListener;

    public CTM(ModContainer modContainer, IEventBus modBus) {
        instance = this;
        modBus.addListener(this::modelRegistry);
        modBus.addListener(this::imc);
        modBus.register((Object)TextureMetadataHandler.INSTANCE);
        Configurations.register(modContainer, modBus);
        TextureTypeRegistry.scan();
        this.definitionManager = new CTMDefinitionManager();
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft != null) {
            ReloadableResourceManager resourceManager = (ReloadableResourceManager)minecraft.getResourceManager();
            resourceManager.registerReloadListener(this.definitionManager.getReloadListener());
        }
        this.reloadListener = new CTMPackReloadListener();
        modBus.addListener(this::reloadListenersLate);
    }

    private void modelRegistry(ModelEvent.RegisterGeometryLoaders event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"ctm", (String)"ctm"), (IGeometryLoader)ModelLoaderCTM.INSTANCE);
    }

    private void imc(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"ctm", (String)"framedblocks", (String)"add_ct_property", () -> AbstractCTMBakedModel.CTM_CONTEXT);
    }

    private void reloadListenersLate(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)this.reloadListener);
    }

    public CTMDefinitionManager getDefinitionManager() {
        return this.definitionManager;
    }

    public CTMPackReloadListener getReloadListener() {
        return this.reloadListener;
    }
}

