/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import java.util.function.Function;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.block.FridgeBlock;
import net.blay09.mods.cookingforblockheads.block.MilkJarBlock;
import net.blay09.mods.cookingforblockheads.block.OvenBlock;
import net.blay09.mods.cookingforblockheads.block.SinkBlock;
import net.blay09.mods.cookingforblockheads.block.ToasterBlock;
import net.blay09.mods.cookingforblockheads.block.entity.FridgeBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.MilkJarBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.OvenBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.SinkBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.ToasterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.InterModComms;
import org.jetbrains.annotations.Nullable;

public class TheOneProbeAddon {
    public static void register() {
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TopInitializer::new);
    }

    @Nullable
    private static <T extends BlockEntity> T tryGetTileEntity(Level level, BlockPos pos, Class<T> tileClass) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null && tileClass.isAssignableFrom(blockEntity.getClass())) {
            return (T)blockEntity;
        }
        return null;
    }

    public static class ProbeInfoProvider
    implements IProbeInfoProvider {
        public ResourceLocation getID() {
            return ResourceLocation.fromNamespaceAndPath((String)"cookingforblockheads", (String)"cookingforblockheads");
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo info, Player playerEntity, Level level, BlockState state, IProbeHitData data) {
            SinkBlockEntity sink;
            if (state.getBlock() instanceof MilkJarBlock) {
                MilkJarBlockEntity tileEntity = TheOneProbeAddon.tryGetTileEntity(level, data.getPos(), MilkJarBlockEntity.class);
                if (tileEntity != null) {
                    this.addMilkJarInfo(tileEntity, info);
                }
            } else if (state.getBlock() instanceof ToasterBlock) {
                ToasterBlockEntity tileEntity = TheOneProbeAddon.tryGetTileEntity(level, data.getPos(), ToasterBlockEntity.class);
                if (tileEntity != null) {
                    this.addToasterInfo(tileEntity, info);
                }
            } else if (state.getBlock() instanceof OvenBlock) {
                OvenBlockEntity tileEntity = TheOneProbeAddon.tryGetTileEntity(level, data.getPos(), OvenBlockEntity.class);
                if (tileEntity != null && tileEntity.hasPowerUpgrade()) {
                    info.text((Component)Component.translatable((String)"waila.cookingforblockheads.heating_unit"));
                }
            } else if (state.getBlock() instanceof FridgeBlock) {
                FridgeBlockEntity tileEntity = TheOneProbeAddon.tryGetTileEntity(level, data.getPos(), FridgeBlockEntity.class);
                if (tileEntity != null && tileEntity.getBaseFridge().hasIceUpgrade()) {
                    info.text((Component)Component.translatable((String)"waila.cookingforblockheads.ice_unit"));
                }
                if (tileEntity != null && tileEntity.getBaseFridge().hasPreservationUpgrade()) {
                    info.text((Component)Component.translatable((String)"waila.cookingforblockheads.preservation_chamber"));
                }
            } else if (state.getBlock() instanceof SinkBlock && (sink = TheOneProbeAddon.tryGetTileEntity(level, data.getPos(), SinkBlockEntity.class)) != null && CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                info.text((Component)Component.translatable((String)"waila.cookingforblockheads.water_stored", (Object[])new Object[]{sink.getFluidTank().getAmount(), sink.getFluidTank().getCapacity()}));
            }
        }

        private void addMilkJarInfo(MilkJarBlockEntity milkJar, IProbeInfo info) {
            info.text((Component)Component.translatable((String)"waila.cookingforblockheads.milk_stored", (Object[])new Object[]{milkJar.getFluidTank().getAmount(), milkJar.getFluidTank().getCapacity()}));
        }

        private void addToasterInfo(ToasterBlockEntity tileEntity, IProbeInfo info) {
            if (tileEntity.isActive()) {
                info.text((Component)Component.translatable((String)"waila.cookingforblockheads.toast_progress", (Object[])new Object[]{(int)(tileEntity.getToastProgress() * 100.0f)}));
                info.progress((int)(tileEntity.getToastProgress() * 100.0f), 100);
            }
        }
    }

    public static class TopInitializer
    implements Function<ITheOneProbe, Void> {
        @Override
        @Nullable
        public Void apply(@Nullable ITheOneProbe top) {
            if (top != null) {
                top.registerProvider((IProbeInfoProvider)new ProbeInfoProvider());
            }
            return null;
        }
    }
}

