/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.blay09.mods.cookingforblockheads.block.OvenBlock;
import net.blay09.mods.cookingforblockheads.block.entity.OvenBlockEntity;
import net.blay09.mods.cookingforblockheads.client.ModModels;
import net.blay09.mods.cookingforblockheads.client.render.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class OvenRenderer
implements BlockEntityRenderer<OvenBlockEntity> {
    private static final RandomSource random = RandomSource.create();

    public OvenRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(OvenBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        DyeColor dyeColor;
        Level level = blockEntity.getLevel();
        if (level == null) {
            return;
        }
        BlockState state = blockEntity.getBlockState();
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        Direction facing = blockEntity.getFacing();
        float doorAngle = blockEntity.getDoorAnimator().getRenderAngle(partialTicks);
        poseStack.pushPose();
        RenderUtils.applyBlockAngle(poseStack, blockEntity.getBlockState());
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        poseStack.mulPose(Axis.XN.rotationDegrees((float)Math.toDegrees(doorAngle)));
        Block block = state.getBlock();
        if (block instanceof OvenBlock) {
            OvenBlock oven = (OvenBlock)block;
            dyeColor = oven.getColor();
        } else {
            dyeColor = DyeColor.WHITE;
        }
        DyeColor blockColor = dyeColor;
        int colorIndex = blockColor.getId();
        BakedModel model = doorAngle < 0.3f && blockEntity.isBurning() ? (BakedModel)ModModels.ovenDoorsActive.get(colorIndex).get() : (BakedModel)ModModels.ovenDoors.get(colorIndex).get();
        dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, model, blockEntity.getBlockState(), blockEntity.getBlockPos(), poseStack, buffer.getBuffer(RenderType.solid()), false, random, 0L, 0);
        poseStack.translate(0.0f, 0.0f, -1.0f);
        dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, (BakedModel)ModModels.ovenDoorHandles.get(colorIndex).get(), blockEntity.getBlockState(), blockEntity.getBlockPos().relative(facing), poseStack, buffer.getBuffer(RenderType.solid()), false, random, 0L, 0);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.0, 1.05, 0.0);
        RenderUtils.applyBlockAngle(poseStack, blockEntity.getBlockState());
        poseStack.scale(0.4f, 0.4f, 0.4f);
        ItemStack itemStack = blockEntity.getToolItem(0);
        if (!itemStack.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(-0.55f, 0.0f, 0.5f);
            poseStack.mulPose(Axis.XP.rotationDegrees(45.0f));
            RenderUtils.renderItem(itemStack, combinedLight, poseStack, buffer, level);
            poseStack.popPose();
        }
        if (!(itemStack = blockEntity.getToolItem(1)).isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.55f, 0.0f, 0.5f);
            poseStack.mulPose(Axis.XP.rotationDegrees(45.0f));
            RenderUtils.renderItem(itemStack, combinedLight, poseStack, buffer, level);
            poseStack.popPose();
        }
        if (!(itemStack = blockEntity.getToolItem(2)).isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(-0.55f, 0.0f, -0.5f);
            poseStack.mulPose(Axis.XP.rotationDegrees(45.0f));
            RenderUtils.renderItem(itemStack, combinedLight, poseStack, buffer, level);
            poseStack.popPose();
        }
        if (!(itemStack = blockEntity.getToolItem(3)).isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.55f, 0.0f, -0.5f);
            poseStack.mulPose(Axis.XP.rotationDegrees(45.0f));
            RenderUtils.renderItem(itemStack, combinedLight, poseStack, buffer, level);
            poseStack.popPose();
        }
        poseStack.popPose();
        if (doorAngle > 0.0f) {
            poseStack.pushPose();
            poseStack.translate(0.0, 0.4, 0.0);
            RenderUtils.applyBlockAngle(poseStack, blockEntity.getBlockState());
            poseStack.scale(0.3f, 0.3f, 0.3f);
            float offsetX = 0.825f;
            float offsetZ = 0.8f;
            for (int i = 0; i < 9; ++i) {
                itemStack = blockEntity.getInternalContainer().getItem(7 + i);
                if (!itemStack.isEmpty()) {
                    poseStack.pushPose();
                    poseStack.translate(offsetX, 0.0f, offsetZ);
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    RenderUtils.renderItem(itemStack, combinedLight, poseStack, buffer, level);
                    poseStack.popPose();
                }
                if (!((offsetX -= 0.8f) < -0.8f)) continue;
                offsetX = 0.825f;
                offsetZ -= 0.8f;
            }
            poseStack.popPose();
        }
    }
}

