/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.mixin;

import dev.shadowsoffire.placebo.util.CachedObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={ItemStack.class})
public class ItemStackMixin
implements CachedObject.CachedObjectSource {
    private volatile Map<ResourceLocation, CachedObject<?>> cachedObjects = null;

    @Override
    public <T> T getOrCreate(ResourceLocation id, Function<ItemStack, T> deserializer, ToIntFunction<ItemStack> hasher) {
        CachedObject cachedObj = this.getOrCreate().computeIfAbsent(id, key -> new CachedObject((ResourceLocation)key, deserializer, hasher));
        return cachedObj.get((ItemStack)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ResourceLocation, CachedObject<?>> getOrCreate() {
        if (this.cachedObjects == null) {
            ItemStackMixin itemStackMixin = this;
            synchronized (itemStackMixin) {
                if (this.cachedObjects == null) {
                    this.cachedObjects = new ConcurrentHashMap();
                }
            }
        }
        return this.cachedObjects;
    }
}

