/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.util.Utils;

public class ParticleLightning
extends Particle {
    private static final ResourceLocation beam = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/white.png");
    public Color color;
    public Color color2;
    public int[] branch = new int[3];
    public int[] angles;
    public int[] angles2;
    public float[] sizes;
    public float[] widths;
    public int fullrotate;
    public int yawrot;
    int life;

    public ParticleLightning(ClientLevel worldIn, Color c, Color c2, double xCoordIn, double yCoordIn, double zCoordIn, float scale, double motionX, double motionY, double motionZ) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, 0.0, 0.0, 0.0);
        this.gCol = 0.7137255f;
        this.rCol = 1.0f;
        this.bCol = 0.75686276f;
        float maxAge = 180.0f;
        this.lifetime = (int)((double)maxAge / (Math.random() * 0.3 + 0.6));
        this.lifetime = (int)((float)this.lifetime * scale);
        Random random = Utils.getRandom((Level)this.level);
        this.oRoll = this.roll = (float)random.nextInt(360) * 0.0174533f;
        this.color = c;
        this.color2 = c2;
        this.branch[0] = random.nextInt(2) + 1;
        this.branch[1] = random.nextInt(2) + 1;
        this.branch[2] = random.nextInt(3) + 1;
        int r = this.branch.length;
        for (int j = 0; j < this.branch.length; ++j) {
            r *= this.branch[j];
        }
        this.angles = new int[r];
        this.angles2 = new int[r];
        this.sizes = new float[r];
        this.widths = new float[r];
        this.sizes[0] = 0.14f;
        this.widths[0] = 0.01f;
        for (int k = 0; k < r; ++k) {
            this.angles[k] = random.nextInt(360);
            this.angles2[k] = random.nextInt(50) + 20;
            if (k > 0) {
                this.sizes[k] = (0.7f + random.nextFloat() * 0.2f) * this.sizes[k - 1];
            }
            if (k <= 0) continue;
            this.widths[k] = 1.0f * this.widths[k - 1];
        }
        this.life = random.nextInt(1);
        this.fullrotate = random.nextInt(20) + 80;
        this.fullrotate = random.nextBoolean() ? -this.fullrotate : this.fullrotate;
        this.yawrot = (int)motionX;
    }

    public void tick() {
        ++this.age;
        if (this.age > this.life * this.branch.length + 3) {
            this.remove();
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.NO_RENDER;
    }

    public void render(VertexConsumer builder, Camera activeRenderInfo, float partial) {
    }

    public static void renderLightningParticle(ParticleLightning particle, double d3, double d4, double d5, PoseStack matrix, float partialTicks) {
        double d0 = particle.xo + (particle.x - particle.xo) * (double)partialTicks;
        double d1 = particle.yo + (particle.y - particle.yo) * (double)partialTicks;
        double d2 = particle.zo + (particle.z - particle.zo) * (double)partialTicks;
        matrix.pushPose();
        matrix.translate(d0 - d3, d1 - d4, d2 - d5);
        float r = (float)particle.color.getRed() / 255.0f;
        float g = (float)particle.color.getGreen() / 255.0f;
        float b = (float)particle.color.getBlue() / 255.0f;
        float r2 = (float)particle.color2.getRed() / 255.0f;
        float g2 = (float)particle.color2.getGreen() / 255.0f;
        float b2 = (float)particle.color2.getBlue() / 255.0f;
        float a = 0.3f;
        float w = particle.widths[0];
        float h = particle.sizes[0];
        RenderUtils.rotateQ(-particle.yawrot, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(particle.fullrotate, 0.0f, 0.0f, 1.0f, matrix);
        MultiBufferSource.BufferSource buf = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderType ringType = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createLightningRenderType(beam, 0));
        RenderType ringType2 = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createLightningRenderType(beam, 1));
        RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 90.0f, w, h, 6, 240, 240, r, g, b, 1.0f, ringType);
        buf.endBatch(ringType);
        ParticleLightning.recursiveLightning(matrix, buf, particle, 0, 0);
        RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 90.0f, w * 1.8f, h, 6, 240, 240, r2, g2, b2, a, ringType2);
        buf.endBatch(ringType2);
        matrix.popPose();
    }

    public static int recursiveLightning(PoseStack matrix, MultiBufferSource.BufferSource buf, ParticleLightning particle, int branchindex, int oindex) {
        float r = (float)particle.color.getRed() / 255.0f;
        float g = (float)particle.color.getGreen() / 255.0f;
        float b = (float)particle.color.getBlue() / 255.0f;
        float r2 = (float)particle.color2.getRed() / 255.0f;
        float g2 = (float)particle.color2.getGreen() / 255.0f;
        float b2 = (float)particle.color2.getBlue() / 255.0f;
        float a = 0.3f;
        int index = oindex;
        if (particle.age > particle.life * branchindex) {
            float agefactor = 1.0f;
            if (branchindex >= particle.branch.length || index >= particle.sizes.length || index >= particle.angles.length) {
                return index;
            }
            float h = particle.sizes[index] * agefactor;
            float w = particle.widths[oindex];
            RenderType ringType = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createRunesRenderType(beam, 1));
            RenderType ringType2 = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createRunesRenderType(beam, 4));
            matrix.translate(0.0f, -h, 0.0f);
            RenderUtils.rotateQ(particle.angles[index], 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(particle.angles2[index], 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 90.0f, w, h, 6, 240, 240, r, g, b, 1.0f, ringType);
            buf.endBatch(ringType);
            if (branchindex < particle.branch.length) {
                for (int i = 0; i < particle.branch[branchindex]; ++i) {
                    oindex = ParticleLightning.recursiveLightning(matrix, buf, particle, branchindex + 1, oindex + 1);
                }
            }
            RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 90.0f, w * 1.8f, h, 6, 240, 240, r2, g2, b2, a, ringType2);
            buf.endBatch(ringType2);
            RenderUtils.rotateQ(-particle.angles2[index], 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.rotateQ(-particle.angles[index], 0.0f, 1.0f, 0.0f, matrix);
            matrix.translate(0.0f, h, 0.0f);
            return oindex;
        }
        return index;
    }
}

